% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.select.R
\name{lags.select}
\alias{lags.select}
\title{Selection of the lag with Information criterion.}
\usage{
lags.select(data, lag.max = 10, include = c("const", "trend", "none",
  "both"), fitMeasure = c("SSR", "LL"), sameSample = TRUE)
}
\arguments{
\item{data}{multivariate time series.}

\item{lag.max}{Maximum number of lags to investigate.}

\item{include}{Type of deterministic regressors to include.}

\item{fitMeasure}{Whether the AIC/BIC should be based on the full likelihood,
or just the SSR. See explanations in \code{\link{logLik.VECM}}.}

\item{sameSample}{Logical. Whether the data should be shortened so that the
AIC/BIC are estimated on the same sample. Default to TRUE.}
}
\value{
An object of class \code{\link{rank.select}}, with \sQuote{print} and
\sQuote{summary methods}, containing among other the matrices of AIC/BIC/HQ.
}
\description{
Selection of the cointegrating rank and the lags with Information criterion
(AIC, BIC).
}
\details{
This function selects the lag according to AIC, BIC and Hannan-Quinn.
}
\examples{


data(barry)

# 
rk_sel <- lags.select(barry)
rk_sel
summary(rk_sel)


}
\seealso{
\code{\link{rank.select}}, the underlying function, to estimate the
rank also.

\code{\link[vars]{VARselect}} in package \pkg{vars}, does basically the same.
}
\author{
Matthieu Stigler
}
\keyword{ts}
