% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ECT.R
\name{plot_ECT}
\alias{plot_ECT}
\title{Plot the Error Correct Term (ECT) response}
\usage{
plot_ECT(x, add.legend = TRUE, legend.location = "topright", ...)
}
\arguments{
\item{x}{object of class \code{\link{VECM}} or \code{\link{TVECM}}}

\item{add.legend}{logical. Whether to add a legend?}

\item{legend.location}{character. Location of the legend, see \code{\link[graphics]{legend}}}

\item{\ldots}{arguments passed to the initial \code{plot} call, see \code{\link[graphics]{plot}}}
}
\value{
a plot, and invisibly the underlying data.frame, containing the ECT and the response for each variable
}
\description{
This plot shows how variables in a (T)VECM respond to deviations from the long-term equilibrium
}
\examples{
data(zeroyld)
vec_l1 <- VECM(zeroyldMeta[, c("long.run", "short.run")], lag =1)
tvec_l1 <- TVECM(zeroyldMeta[, c("long.run", "short.run")], lag =1, 
                plot  = FALSE, trace = FALSE, th1 = list(exact = -1.263))

plot_ECT(vec_l1)
plot_ECT(tvec_l1, legend.location = "bottomright")
}
