% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smaniplot.r
\name{bandfilt}
\alias{bandfilt}
\title{\code{bandfilt} does a bandpass filtering of a time series}
\usage{
bandfilt(y, q, pl, pu)
}
\arguments{
\item{y}{the series, a vector or a time series}

\item{q}{scalar, half of length of symmetric weights}

\item{pl}{scalar, lower periodicity ( >= 2 )}

\item{pu}{scalar, upper periodicity ( > pl )}
}
\value{
yf (n,1) vector, the centered filtered time series with NA's at beginning and ending
}
\description{
\code{bandfilt} does a bandpass filtering of a time series
}
\examples{
data(GDP)
yf <- bandfilt(GDP,5,2,6)
\donttest{plot(GDP); lines(yf+mean(GDP),col="red")   }
}
