% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{summary.dec.sim}
\alias{summary.dec.sim}
\title{Summarizing simulation results from a dec.sim object}
\usage{
\method{summary}{dec.sim}(object, pt, ...)
}
\arguments{
\item{object}{an object of class \code{"dec.sim"}, a result of a call to \code{dec.sim} or \code{sl.sim}.}

\item{pt}{target toxicity for each scenario.}

\item{...}{Not used argument.}
}
\description{
\code{summary} method for class \code{"dec.sim"}.
}
\details{
\code{summary} is used for formating important statistics for dose-finding simulation. Giving the target toxicity, it returns the probability of selecting current dose level as the MTD, probability of selecting the true MTD, probability of subjects treated at or below the true MTD, etc. The MTD is defined as the highest dose level such that the toxicity probability is less than target toxicity probability, if target is less than the smallest probability, then the lowest dose level is set as MTD. For example, if target is 0.3 and true toxicity for five doses are 0.1, 0.25, 0.35, 0.40, then MTD is dose 2.
}
\examples{
test.file <- system.file("extdata", "testS.csv", package = "tsdf")
dt <- dec.table(0.6,0.4,0.2,0.3,0.3,c(3,3,3))
out <- sl.sim(dt$table, test.file)
pt <- c(0.3, 0.4)
summary(out, pt)
}
