% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.R
\name{group_by.tbl_ts}
\alias{group_by.tbl_ts}
\alias{ungroup.grouped_ts}
\title{Group by one or more variables}
\usage{
\method{group_by}{tbl_ts}(.data, ..., add = FALSE)

\method{ungroup}{grouped_ts}(x, ...)
}
\arguments{
\item{.data}{A tsibble.}

\item{...}{Variables to group by. It follows a consistent rule as the "key"
expression in \link{as_tsibble}, which means \code{|} for nested variables and \code{,} for
crossed variables. The following operations will affect the tsibble structure
based on the way how the variables are grouped.}

\item{add}{\code{TRUE} adds to the existing groups, otherwise overwrites.}

\item{x}{A (grouped) tsibble.}
}
\description{
Group by one or more variables
}
\examples{
data(tourism)
tourism \%>\%
  group_by(Region | State) \%>\%
  summarise(geo_trips = sum(Trips))
}
\seealso{
\link[dplyr:group_by]{dplyr::group_by}

\link[dplyr:ungroup]{dplyr::ungroup}
}
