% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{pull_interval}
\alias{pull_interval}
\title{Extract time interval from a vector}
\usage{
pull_interval(x)
}
\arguments{
\item{x}{A vector of \code{POSIXt}, \code{Date}, \code{yearmonth}, \code{yearquarter}, \code{difftime},
\code{hms}, \code{integer}, \code{numeric}.}
}
\value{
an "interval" class (a list) includes "year",
"quarter", "month", "week", "day", "hour", "minute", "second", "millisecond",
"microsecond", "nanosecond", "unit".
}
\description{
Assuming regularly spaced time, the \code{pull_interval()} returns a list of time
components as the "interval" class.
}
\details{
\code{index_valid()} and \code{pull_interval()} make a tsibble extensible to
support custom time index.
}
\examples{
x <- seq(as.Date("2017-10-01"), as.Date("2017-10-31"), by = 3)
pull_interval(x)
}
