% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsibble2ts.R
\name{as.ts.tbl_ts}
\alias{as.ts.tbl_ts}
\title{Coerce a tsibble to a time series}
\usage{
\method{as.ts}{tbl_ts}(x, value, frequency = NULL, fill = NA, ...)
}
\arguments{
\item{x}{A \code{tbl_ts} object.}

\item{value}{A measured variable of interest to be spread over columns, if
multiple measures.}

\item{frequency}{A smart frequency with the default \code{NULL}. If set, the
preferred frequency is passed to \code{ts()}.}

\item{fill}{A value replaces missing values.}

\item{...}{Ignored for the function.}
}
\value{
A \code{ts} object.
}
\description{
Coerce a tsibble to a time series
}
\examples{
# a monthly series ----
x1 <- as_tsibble(AirPassengers)
as.ts(x1)

# equally spaced over trading days, not smart enough to guess frequency ----
x2 <- as_tsibble(EuStockMarkets)
head(as.ts(x2, frequency = 260))
}
