% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.R
\name{slide}
\alias{slide}
\alias{slide_dfr}
\alias{slide_dfc}
\title{Sliding window calculation}
\usage{
slide(.x, .f, ..., .size = 1, .step = 1, .fill = NA,
  .partial = FALSE, .align = "right", .bind = FALSE)

slide_dfr(.x, .f, ..., .size = 1, .step = 1, .fill = NA,
  .partial = FALSE, .align = "right", .bind = FALSE, .id = NULL)

slide_dfc(.x, .f, ..., .size = 1, .step = 1, .fill = NA,
  .partial = FALSE, .align = "right", .bind = FALSE)
}
\arguments{
\item{.x}{An object to slide over.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.step}{A positive integer for calculating at every specified step
instead of every single step.}

\item{.fill}{A value to fill at the left/center/right of the data range depending
on \code{.align} (\code{NA} by default).  \code{NULL} means no filling.}

\item{.partial}{if \code{TRUE}, partial sliding.}

\item{.align}{Align index at the "\strong{r}ight", "\strong{c}entre"/"center", or "\strong{l}eft"
of the window. If \code{.size} is even for center alignment, "centre-right" & "centre-left"
is needed.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{Either a string or \code{NULL}. If a string, the output will contain
a variable with that name, storing either the name (if \code{.x} is named) or
the index (if \code{.x} is unnamed) of the input. If \code{NULL}, the default, no
variable will be created.

Only applies to \code{_dfr} variant.}
}
\value{
if \code{.fill != NULL}, it always returns the same length as input.
}
\description{
\lifecycle{questioning}

\strong{The rolling window family will be deprecated in the future. Please consider
using the \href{https://davisvaughan.github.io/slide}{slide} package.}

Rolling window with overlapping observations:
\itemize{
\item \code{slide()} always returns a list.
\item \code{slide_lgl()}, \code{slide_int()}, \code{slide_dbl()}, \code{slide_chr()} use the same
arguments as \code{slide()}, but return vectors of the corresponding type.
\item \code{slide_dfr()} & \code{slide_dfc()} return data frames using row-binding & column-binding.
}
}
\details{
The \code{slide()} function attempts to tackle more general problems using
the purrr-like syntax. For some specialist functions like \code{mean} and \code{sum},
you may like to check out for \strong{RcppRoll} for faster performance.

\code{slide()} is intended to work with list (and column-wise data frame). To
perform row-wise sliding window on data frame, please check out \code{\link[=pslide]{pslide()}}.
\itemize{
\item \code{.partial = TRUE} allows for partial sliding. Window contains observations
outside of the vector will be treated as value of \code{.fill}, which will be passed to \code{.f}.
\item \code{.partial = FALSE} restricts calculations to be done on complete sliding windows.
Window contains observations outside of the vector will return the value \code{.fill}.
}
}
\examples{
x <- 1:5
lst <- list(x = x, y = 6:10, z = 11:15)
slide_dbl(x, mean, .size = 2)
slide_dbl(x, mean, .size = 2, align = "center")
slide_lgl(x, ~ mean(.) > 2, .size = 2)
slide(lst, ~., .size = 2)
}
\seealso{
\itemize{
\item \link{future_slide} for parallel processing
\item \link{tile} for tiling window without overlapping observations
\item \link{stretch} for expanding more observations
}

Other sliding window functions: \code{\link{slide2}}
}
\concept{sliding window functions}
\alias{slide_lgl}
\alias{slide_chr}
\alias{slide_int}
\alias{slide_dbl}
