% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.R
\name{stretch2}
\alias{stretch2}
\alias{stretch2_dfr}
\alias{stretch2_dfc}
\alias{pstretch}
\alias{pstretch_dfr}
\alias{pstretch_dfc}
\title{Stretching window calculation over multiple simultaneously}
\usage{
stretch2(.x, .y, .f, ..., .step = 1, .init = 1, .fill = NA, .bind = FALSE)

stretch2_dfr(
  .x,
  .y,
  .f,
  ...,
  .step = 1,
  .init = 1,
  .fill = NA,
  .bind = FALSE,
  .id = NULL
)

stretch2_dfc(.x, .y, .f, ..., .step = 1, .init = 1, .fill = NA, .bind = FALSE)

pstretch(.l, .f, ..., .step = 1, .init = 1, .fill = NA, .bind = FALSE)

pstretch_dfr(
  .l,
  .f,
  ...,
  .step = 1,
  .init = 1,
  .fill = NA,
  .bind = FALSE,
  .id = NULL
)

pstretch_dfc(.l, .f, ..., .step = 1, .init = 1, .fill = NA, .bind = FALSE)
}
\arguments{
\item{.x}{Objects to slide over simultaneously.}

\item{.y}{Objects to slide over simultaneously.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.step}{A positive integer for calculating at every specified step
instead of every single step.}

\item{.init}{A positive integer for an initial window size.}

\item{.fill}{A value to fill at the left/center/right of the data range depending
on \code{.align} (\code{NA} by default).  \code{NULL} means no filling.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{Either a string or \code{NULL}. If a string, the output will contain
a variable with that name, storing either the name (if \code{.x} is named) or
the index (if \code{.x} is unnamed) of the input. If \code{NULL}, the default, no
variable will be created.

Only applies to \code{_dfr} variant.}

\item{.l}{A list of vectors, such as a data frame. The length of \code{.l}
determines the number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\description{
\lifecycle{questioning}

\strong{The rolling window family will be deprecated in the future. Please consider
using the \href{https://davisvaughan.github.io/slider}{slider} package.}

Fixing an initial window and expanding more observations:
\itemize{
\item \code{stretch2()} and \code{pstretch()} always returns a list.
\item \code{stretch2_lgl()}, \code{stretch2_int()}, \code{stretch2_dbl()}, \code{stretch2_chr()} use the same
arguments as \code{stretch2()}, but return vectors of the corresponding type.
\item \code{stretch2_dfr()} \code{stretch2_dfc()} return data frames using row-binding & column-binding.
}
}
\examples{
x <- 1:5
y <- 6:10
z <- 11:15
lst <- list(x = x, y = y, z = z)
df <- as.data.frame(lst)
stretch2(x, y, sum, .step = 2)
stretch2(lst, lst, ~., .step = 2)
stretch2(df, df, ~., .step = 2)
pstretch(lst, sum, .step = 1)
pstretch(list(lst, lst), ~., .step = 2)

###
# row-wise stretching over data frame
###

x <- as.Date("2017-01-01") + 0:364
df <- data.frame(x = x, y = seq_along(x))

tibble(
  data = pstretch(df, function(...) as_tibble(list(...)), .init = 10)
)
}
\seealso{
\itemize{
\item \link{slide2} for sliding window with overlapping observations
\item \link{tile2} for tiling window without overlapping observations
}

Other stretching window functions: 
\code{\link{stretch}()}
}
\concept{stretching window functions}
\alias{stretch2_lgl}
\alias{stretch2_chr}
\alias{stretch2_dbl}
\alias{stretch2_int}
\alias{pstretch_lgl}
\alias{pstretch_chr}
\alias{pstretch_dbl}
\alias{pstretch_int}
