% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearweek.R
\name{yearweek}
\alias{yearweek}
\alias{make_yearweek}
\alias{is_yearweek}
\alias{is_53weeks}
\title{Represent year-week based on the ISO 8601 standard (with flexible start day)}
\usage{
yearweek(x, week_start = getOption("lubridate.week.start", 1))

make_yearweek(
  year = 1970L,
  week = 1L,
  week_start = getOption("lubridate.week.start", 1)
)

is_yearweek(x)

is_53weeks(year, week_start = getOption("lubridate.week.start", 1))
}
\arguments{
\item{x}{Other object.}

\item{week_start}{An integer between 1 (Monday) and 7 (Sunday) to specify
the day on which week starts following ISO conventions. Default to 1 (Monday).
Use \code{options(lubridate.week.start = 7)} to set this parameter globally.}

\item{year, week}{A vector of numerics give years and weeks.}
}
\value{
year-week (\code{yearweek}) objects.

\code{TRUE}/\code{FALSE} if the year has 53 ISO weeks.
}
\description{
\lifecycle{stable}

Create or coerce using \code{yearweek()}.
}
\section{Display}{

Use \code{format()} to display \code{yearweek}, \code{yearmonth}, and \code{yearquarter} objects
in required formats.
Please see \code{\link[=strptime]{strptime()}} details for supported conversion specifications.
}

\examples{
# coerce POSIXct/Dates to yearweek
x <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "1 week")
yearweek(x)
yearweek(x, week_start = 7)

# parse characters
yearweek(c("2018 W01", "2018 Wk01", "2018 Week 1"))

# seq() and arithmetic
wk1 <- yearweek("2017 W50")
wk2 <- yearweek("2018 W12")
seq(from = wk1, to = wk2, by = 2)
wk1 + 0:9

# display formats
format(c(wk1, wk2), format = "\%V/\%Y")

make_yearweek(year = 2021, week = 10:11)
make_yearweek(year = 2020:2021, week = 10:11)

is_53weeks(2015:2016)
is_53weeks(1969)
is_53weeks(1969, week_start = 7)
}
\seealso{
\link{scale_x_yearweek} and others for ggplot2 scales

Other index functions: 
\code{\link{yearmonth}()},
\code{\link{yearquarter}()}
}
\concept{index functions}
