% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_diff.R
\name{ts_norm_diff}
\alias{ts_norm_diff}
\title{Time Series Diff}
\usage{
ts_norm_diff(outliers = outliers_boxplot())
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}
}
\value{
returns a \code{ts_norm_diff} object.
}
\description{
This function calculates the difference between the values of a time series.
}
\examples{
# time series to normalize
library(daltoolbox)
data(sin_data)

# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_diff()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,9])
}
