% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansbary.R
\name{drezner}
\alias{drezner}
\title{Run an Improved Version of the Algorithm by Drezner, Mehrez and Wesolowsky for Finding Barycenters
Based on Limited Distances}
\usage{
drezner(clusterx, clustery, penalty, p = 2, reduction = TRUE, aleph = FALSE)
}
\arguments{
\item{clusterx, clustery}{vectors of x- and y-coordinates for the point cloud.}

\item{penalty}{the \eqn{p}-th power of the Euclidean distance is cut off at \eqn{2 \cdot \code{penalty}^p}{2*\code{penalty}^p}. 
To cut off at \eqn{C}, set \eqn{\code{penalty} = (C/2)^{1/p}}.}

\item{p}{the exponent for the distances and cutoffs. \emph{Currently only implemented for \code{p=2}.}}

\item{reduction}{logical. Shall the pre-screening procedure be applied?}

\item{aleph}{logical. Shall the returned value be \code{NA} if no good barycenter can be found?}
}
\value{
A list containing the following components:
        \item{barycenterx,barycentery}{the \eqn{x}- and \eqn{y}-coordinates of the barycenter \eqn{b^*}{b*}
        that was found. May both be \code{NA} if option \code{aleph=TRUE} and no actual barycenter is good
        enough.}
        \item{cost}{the total cost \eqn{\gamma(b^*)}{gamma(b^*)} of the barycenter .}
        \item{calculations}{If \code{reduction=FALSE}, the number of point pairs from which the barycenter candidates are calculated. 
        Each point pair yields eight candidates.} 
        \item{skipped}{If \code{reduction=TRUE}, the number of skipped point pairs
        due to the pre-screening procedure.}
}
\description{
Find a barycenter of a 2-d point cloud based on minimizing the \eqn{p}-th power of the Euclidean 
distance, cut off at \eqn{C=2*\code{penalty}^p}. In addition to using a pre-screening procedure to further
alleviate the computational burden of the original algorithm, an option may be specified 
to allow the algorithm to return \code{NA} if no location in 2-d space is "good enough".
}
\details{
For points \eqn{z_1,\ldots,z_n}{z_1,...,z_n} with \eqn{x}-coordinates \code{clusterx} and 
          \eqn{y}-coordinates \code{clustery} find a minimizer \eqn{b^*}{b*} (barycenter) of
          \deqn{\gamma(b) = \sum_{i=1}^n \min\{\|z_i-b\|^p, C\}}{\gamma(b) = \sum_{i=1}^n \min\{\|z_i-b\|^p, C\}}
          or return \code{NA} if \eqn{\gamma(b) > \frac{n}{2}C}{\gamma(b) > (n/2)*C} for all \eqn{b \in \mathbf{R}^2}{b in R^2}.
          
          The original algorithm is due to Drezner, Mehrez and Wesolowsky (1991). The improvements are from
          Müller, Schöbel and Schuhmacher (2022).
}
\examples{
  x <- rnorm(20)
  y <- rnorm(20)
  plot(x, y, asp=1)
  res <- drezner(x, y, 2)
  points(res$barycenterx, res$barycentery, col=2)
  res <- drezner(x, y, 0.5)
  points(res$barycenterx, res$barycentery, col=4)

}
\references{
Zvi Drezner, Avram Mehrez and George O. Wesolowsky (1991).\cr
            The facility location problem with limited distances.\cr
            Transportation Science 25.3 (1991): 183-187.\cr
            www.jstor.org/stable/25768490\cr
            \cr
            Raoul Müller, Anita Schöbel and Dominic Schuhmacher (2022).\cr
            Location problems with cutoff.\cr
            Preprint \href{https://arxiv.org/abs/2203.00910}{arXiv:2203.00910}
}
\author{
Raoul Müller  \email{raoul.mueller@uni-goettingen.de}
}
