% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build}
\alias{build}
\title{Build a Docker image}
\usage{
build(
  dockerfile = here::here("Dockerfile"),
  image_name = "tugboat",
  tag = "latest",
  platforms = c("linux/amd64", "linux/arm64"),
  build_args = NULL,
  build_context = dirname(dockerfile),
  push = FALSE,
  dh_username = NULL,
  dh_password = NULL
)
}
\arguments{
\item{dockerfile}{The path to the Dockerfile. The default value
is a file named \code{Dockerfile} in the project directory surfaced by
\link[here:here]{here::here}.}

\item{image_name}{A string specifying the Docker image name. Default
is \code{tugboat}.}

\item{tag}{A string specifying the image tag. Default is \code{latest}.}

\item{platforms}{A vector of strings. Which platforms to build images for.
Default is both \code{linux/amd64} and \code{linux/arm64}.}

\item{build_args}{A vector of strings specifying additional build arguments
to pass to the \verb{docker buildx build} command. Optional.}

\item{build_context}{The directory that is the build context for the
image(s). Default value is the directory returned by \link[here:here]{here::here}.}

\item{push}{A boolean indicating whether to push to DockerHub.}

\item{dh_username}{A string specifying the DockerHub username. Only
necessary if \code{push == TRUE}.}

\item{dh_password}{A string specifying the DockerHub password. Only
necessary if \code{push == TRUE}.}
}
\value{
The name of the built Docker image as a string.
}
\description{
A simple utility to quickly build a Docker image from a Dockerfile.
}
\examples{
\dontrun{
dock <- create(
  project = here::here(),
  FROM = "rocker/rstudio",
  exclude = c("/data", "/examples")
)

image_name <- build(
  dockerfile = here::here("Dockerfile"),
  image_name = "awesome_analysis",
  push = TRUE,
  dh_username = Sys.getenv("DH_USERNAME"),
  dh_password = Sys.getenv("DH_PASSWORD")
)
}
}
