% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autoplot.tune_results}
\alias{autoplot.tune_results}
\title{Plot tuning search results}
\usage{
\method{autoplot}{tune_results}(
  object,
  type = c("marginals", "parameters", "performance"),
  metric = NULL,
  width = NULL,
  ...
)
}
\arguments{
\item{object}{A tibble of results from \code{\link[=tune_grid]{tune_grid()}} or \code{\link[=tune_bayes]{tune_bayes()}}.}

\item{type}{A single character value. Choices are \code{"marginals"} (for a plot
'of each predictor versus performance), \code{"parameters"} (each parameter versus
search iteration), or \code{"performance"} (performance versus iteration). The
latter two choices are only used for \code{\link[=tune_bayes]{tune_bayes()}}.}

\item{metric}{A character vector or \code{NULL} for which metric to plot. By
default, all metrics will be shown via facets.}

\item{width}{A number for the width of the confidence interval bars when
\code{type = "perfomance"}. A value of zero prevents them from being shown.}

\item{...}{Not currently used.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot tuning search results
}
\details{
The parameters are currently represented in their natural units.

A single categorical tuning parameter is supported when other numeric
parameters are also in the results. Any number of numeric tuning parameters
can be used.
}
\examples{
\donttest{
# For grid search:
data("example_ames_knn")

# Plot the tuning parameter values versus performance
autoplot(ames_grid_search, metric = "rmse")


# For iterative search:
# Plot the tuning parameter values versus performance
autoplot(ames_iter_search, metric = "rmse", type = "marginals")

# Plot tuning parameters versus iterations
autoplot(ames_iter_search, metric = "rmse", type = "parameters")

# Plot performance over iterations
autoplot(ames_iter_search, metric = "rmse", type = "performance")
}
}
\seealso{
\code{\link[=tune_grid]{tune_grid()}}, \code{\link[=tune_bayes]{tune_bayes()}}
}
