% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunable.R
\name{tunable.model_spec}
\alias{tunable.model_spec}
\alias{tunable.workflow}
\alias{tunable.linear_reg}
\alias{tunable.logistic_reg}
\alias{tunable.multinomial_reg}
\alias{tunable.boost_tree}
\alias{tunable.rand_forest}
\alias{tunable.mars}
\alias{tunable.decision_tree}
\title{Find recommended methods for generating parameter values}
\usage{
\method{tunable}{model_spec}(x, ...)

\method{tunable}{workflow}(x, ...)

\method{tunable}{linear_reg}(x, ...)

\method{tunable}{logistic_reg}(x, ...)

\method{tunable}{multinomial_reg}(x, ...)

\method{tunable}{boost_tree}(x, ...)

\method{tunable}{rand_forest}(x, ...)

\method{tunable}{mars}(x, ...)

\method{tunable}{decision_tree}(x, ...)
}
\arguments{
\item{x}{An object, such as a workflow or \code{parsnip} model
specification.}

\item{...}{Not currently used.}
}
\value{
A tibble with a column for the parameter \code{name}, information on the
\emph{default} method for generating a corresponding parameter object, the
\code{source} of the parameter (e.g. "model_spec", etc.), and the \code{component}
within the source. For the \code{component} column, a little more specificity is
given about the location of the parameter (e.g. "boost_tree" for models).
The \code{component_id} column contains the unique step \code{id} field or, for
models, a logical for whether the model specification argument was a main
parameter or one associated with the engine.
}
\description{
\code{\link[=tunable]{tunable()}} determines which parameters in an object \emph{can} be tuned along
with information about the parameters.
}
\details{
For a model specification, an engine must be chosen.

If the object has no tunable parameters, a tibble with no rows is returned.

The information about the default parameter object takes the form of a
named list with an element for the function call and an optional element for
the source of the function (e.g. the \code{dials} package). For model
specifications, if the parameter is unknown to the underlying \code{tunable}
method, a \code{NULL} is returned.
}
\examples{
\donttest{
library(parsnip)

boost_tree() \%>\%
  set_engine("xgboost") \%>\%
  tunable()

boost_tree() \%>\%
  set_engine("C5.0", rules = TRUE) \%>\%
  tunable()
}

}
\keyword{internal}
