% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_file.R
\name{show_file}
\alias{show_file}
\title{Display the contents of a text file that match a pattern}
\usage{
show_file(path, start = 1, end = NULL, pattern = NULL, chunk = "None")
}
\arguments{
\item{path}{A character vector representing the path to the text file.}

\item{start}{An integer specifying the starting row number (inclusive) to consider. Default is 1.
If negative, it represents the number of lines to print from the end of the file.}

\item{end}{An integer specifying the ending row number (inclusive) to consider. Default is the last row.}

\item{pattern}{A regular expression pattern to match against each row. Default is NULL (no pattern matching).}

\item{chunk}{A character string indicating whether to print code lines within R code chunks.
Possible values are "None" (default), "All" (print all code chunks),
or "Last" (print only the last code chunk).}
}
\value{
The function prints the contents of the specified range of rows that match the pattern (if provided)
or the code lines within R code chunks (if chunk is TRUE) to the console. If no rows match the pattern,
nothing is printed. If start is negative, the function prints the last abs(start) lines, ignoring
missing lines at the end of the file.
}
\description{
This function reads the contents of a text file and either prints the specified range of rows
that match a given regular expression pattern or prints the code lines within R code chunks.
If start is a negative number, it prints the last abs(start) lines, ignoring missing lines at the end of the file.
}
\examples{
\dontrun{
# Display all rows of a text file
show_file("path/to/your/file.txt")

# Display rows 5 to 10 of a text file
show_file("path/to/your/file.txt", start = 5, end = 10)

# Display all rows of a text file that contain the word "example"
show_file("path/to/your/file.txt", pattern = "example")

# Print code lines within R code chunks
show_file("path/to/your/file.txt", chunk = TRUE)

# Display the last 5 lines of a text file, ignoring missing lines at the end
show_file("path/to/your/file.txt", start = -5)
}

}
