% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvA.R
\name{tvAcoef}
\alias{tvAcoef}
\title{Time-Varying Coefficient Arrays of the Lagged Endogenous Variables of a TV-VAR (no intercept).}
\usage{
tvAcoef(x)
}
\arguments{
\item{x}{An object of class \code{tvvar} generated by \code{\link{tvVAR}}.}
}
\value{
A list object with coefficient arrays for the lagged endogenous variables.
}
\description{
Returns the estimated coefficients of the lagged endogenous variables as an array.
 Given an estimated time varying VAR of the form:
\deqn{\hat{\bold{y}}_t = \hat{A}_{1t} \bold{y}_{t-1} + \ldots + \hat{A}_{pt} \bold{y}_{t-p} + \hat{C}_tD_t}
the function returns a list for each equation with \eqn{\hat{A}_{1t} | \ldots | \hat{A}_{pt} | \hat{C}_t)}
set of arrays
}
\examples{
data(Canada, package="vars")
var.2p <- vars::VAR(Canada, p = 2, type = "const")
tvvar.2p <- tvVAR(Canada, p = 2, type = "const")
A <- vars::Acoef(var.2p)
tvA <- tvAcoef(tvvar.2p)

}
