% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvAR.R
\name{tvAR}
\alias{tvAR}
\alias{tvar-class}
\alias{tvar}
\title{Time-Varying Autoregressive Model}
\usage{
tvAR(y, p = 1, z = NULL, ez = NULL, bw = NULL, cv.block = 0,
  type = c("const", "none"), exogen = NULL, fixed = NULL,
  est = c("lc", "ll"), tkernel = c("Epa", "Gaussian"),
  singular.ok = TRUE)
}
\arguments{
\item{y}{A vector with the dependent variable.}

\item{p}{A scalar indicating the number of lags in the model.}

\item{z}{A vector with the smoothing variable.}

\item{ez}{(optional) A scalar or vector with the smoothing estimation values. If 
values are included then the vector \code{z} is used.}

\item{bw}{An opcional scalar or vector of length the number of equations. It represents
the bandwidth in the estimation of coefficients. If NULL, it is selected
by cross validation.}

\item{cv.block}{A positive scalar with the size of the block in leave one block out cross-validation.
By default 'cv.block=0' meaning leave one out cross-validation.}

\item{type}{A character 'const' if the model contains an intercept and 'none' otherwise.}

\item{exogen}{A matrix or data.frame with the exogenous variables (optional)}

\item{fixed}{(optional) numeric vector of the same length as the total number of parameters.
If supplied, only NA entries in fixed will be varied.}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant
or "ll" for local linear.}

\item{tkernel}{The type of kernel used in the coefficients estimation method,
one of Epanesnikov ("Epa") or "Gaussian".}

\item{singular.ok}{Logical. If FALSE, a singular model is an error.}
}
\value{
An object of class \code{tvar} with the following components:
\item{tvcoef}{A vector of dimension obs (obs = number of observations - number lags),
 with the time-varying coefficients estimates.}
\item{fitted}{The fitted values.}
\item{residuals}{Estimation residuals.}
\item{x}{A matrix of model data, with lagged y and exogenous variables.}
\item{y}{A vector with the dependent data used in the model.}
\item{z}{A vector with the smoothing variable in the model.}
\item{ez}{A vector with the smoothing estimation values.}
\item{y.orig}{A vector with the original variable y.}
\item{bw}{Bandwidth of mean estimation.}
\item{type}{Whether the model has a constant or not.}
\item{exogen}{A matrix or data.frame with other exogenous variables.}
\item{p}{Number of lags}
\item{obs}{Number of observations in estimation.}
\item{totobs}{Number of observations in the original set.}
\item{level}{Confidence interval range.}
\item{runs}{Number of bootstrap replications.}
\item{tboot}{Type of bootstrap.}
\item{BOOT}{List with all bootstrap replications of \code{tvcoef}, if done.}
}
\description{
\code{tvAR} is used to fit an autorregressive model with time varying coefficients.
}
\details{
It is a special case of linear model in which the regressors are lags of the
dependent variable. If any variable is included in the \code{xreg} term, these are added 
to the regressors matrix. A time-varying coefficients linear regression (with an
intercept if type = "const") is fitted.
}
\examples{

## Estimate coefficients of different realized variance models
data("RV")
RV2 <- head(RV, 2000)
RV <- RV2$RV
RV_week <- RV2$RV_week
RV_month <- RV2$RV_month
RQ <- RV2$RQ_lag_sqrt
##Corsi (2009) HAR model
HAR <- arima(RV, order = c(1, 0, 0), xreg = cbind (RV_week, RV_month))
print(HAR)

##Chen et al (2017) TVC-HAR model 
TVCHAR <- tvAR (RV, p = 1, exogen = cbind (RV_week, RV_month), bw = 20)
print(TVCHAR)

##Casas et al (2018) TV-HARQ model
tvHARQ <- tvAR (RV, p = 1, exogen = cbind (RV_week, RV_month), 
z=RQ, bw = 0.0062)
print(tvHARQ)

}
\references{
Cai, Z. (2007) Trending time-varying coefficient time series with serially
correlated errors, \emph{Journal of Econometrics}, 136, pp. 163-188.

Casas, I., Mao, X. and Veiga, H. (2018) Reexamining financial and economic 
predictability with new estimators of realized variance and variance 
risk premium. Url= http://pure.au.dk/portal/files/123066669/rp18_10.pdf

Chen, X. B., Gao, J., Li, D., and Silvapulle, P (2017) Nonparametric estimation and 
forecasting for time-varying coefficient realized volatility models,
\emph{Journal of Business \& Economic Statistics}, online, 1-13.

Corsi, F. (2009) A simple approximate long-memory model of realized 
volatility. \emph{Journal of Financial Econometrics}, 7, 174-196.
}
\seealso{
\code{\link{bw}}, \code{\link{tvLM}}, \code{\link{confint}}, 
\code{\link{plot}}, \code{\link{print}} and \code{\link{summary}}
}
