% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{ks_stat}
\alias{ks_stat}
\alias{ks_test}
\title{Kolmogorov-Smirnov Test}
\usage{
ks_stat(a, b, power = 1)

ks_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
A two-sample test using the Kolmogorov-Smirnov test statistic (\code{ks_stat}).
}
\details{
The KS test compares two ECDFs by looking at the maximum difference between them. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then \deqn{KS = max |E(x)-F(x)|^p} for values of x in the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample.

In the example plot below, the KS statistic is the height of the vertical black line. \figure{ks.png}{Example KS stat plot}
}
\section{Functions}{
\itemize{
\item \code{ks_stat}: Kolmogorov-Smirnov test statistic

\item \code{ks_test}: Permutation based two sample Kolmogorov-Smirnov test
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
ks_test(vec1,vec2)
}
\seealso{
\code{\link[=dts_test]{dts_test()}} for a more powerful test statistic. See \code{\link[=kuiper_test]{kuiper_test()}} or \code{\link[=cvm_test]{cvm_test()}} for the natural successors to this test statistic.
}
