% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mechanisms.R
\name{est_g_cens}
\alias{est_g_cens}
\title{Estimate the Censoring Mechanism}
\usage{
est_g_cens(
  C_cens,
  A,
  W,
  samp_weights = rep(1, length(C_cens)),
  fit_type = c("sl", "glm"),
  glm_formula = "C_cens ~ .",
  sl_learners = NULL
)
}
\arguments{
\item{C_cens}{A \code{numeric} vector of loss to follow-up indicators.}

\item{A}{A \code{numeric} vector of observed exposure values.}

\item{W}{A \code{numeric} matrix of observed baseline covariate values.}

\item{samp_weights}{A \code{numeric} vector of observation-level sampling
weights, as produced by the internal procedure to estimate the two-phase
sampling mechanism \code{\link{est_samp}}.}

\item{fit_type}{A \code{character} indicating whether to use GLMs or Super
Learner to fit the censoring mechanism. If option "glm" is selected, the
argument \code{glm_formula} must NOT be \code{NULL}, instead containing a
model formula (as per \code{\link[stats]{glm}}) as a \code{character}. If
the option "sl" is selected, the argument \code{sl_learners} must NOT be
\code{NULL}; instead, an instantiated \pkg{sl3} \code{Lrnr_sl} object,
specifying learners and a metalearner for the Super Learner fit, must be
provided. Consult the documentation of \pkg{sl3} for details.}

\item{glm_formula}{A \code{character} giving a \code{\link[stats]{formula}}
for fitting a (generalized) linear model via \code{\link[stats]{glm}}.}

\item{sl_learners}{Object containing a set of instantiated learners from the
\pkg{sl3}, to be used in fitting an ensemble model.}
}
\value{
A \code{numeric} vector of the propensity score for censoring.
}
\description{
Estimate the Censoring Mechanism
}
\details{
Compute the censoring mechanism for the observed data, in order to
 apply a joint intervention for removing censoring by re-weighting.
}
