% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{parameterChecks}
\alias{parameterChecks}
\title{Check the parameter vector is specified correctly}
\usage{
parameterChecks(p, M, params, pars, alphas, StMAR = FALSE,
  constraints = FALSE)
}
\arguments{
\item{p}{a positive integer specifying the order of AR coefficients.}

\item{M}{a positive integer specifying the number of mixture components or regimes.}

\item{params}{a real valued parameter vector specifying the model.
\describe{
  \item{For \strong{GMAR} model:}{Size \eqn{(M(p+3)-1x1)} vector \strong{\eqn{\theta}}\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
    \eqn{\alpha_{1},...,\alpha_{M-1}}), where \strong{\eqn{\upsilon_{m}}}\eqn{=(\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,
    \sigma_{m}^2)} and \strong{\eqn{\phi_{m}}}=\eqn{(\phi_{m,1},...,\phi_{m,p}), m=1,...,M}.}
  \item{For \strong{StMAR} model:}{Size \eqn{(M(p+4)-1x1)} vector (\strong{\eqn{\theta, \nu}})\eqn{=}(\strong{\eqn{\upsilon_{1}}},...,\strong{\eqn{\upsilon_{M}}},
    \eqn{\alpha_{1},...,\alpha_{M-1}, \nu_{1},...,\nu_{M}}).}
}}

\item{pars}{a parameter matrix containing parameters \eqn{(\phi_{i,0},...,\phi_{i,p}, \sigma_{i}^2)}
so that i:th column denotes i:th component.}

\item{alphas}{size Mx1 parameter vector containing mixing weights for all components.}

\item{StMAR}{an (optional) logical argument stating whether StMAR model should be considered instead of GMAR model. Default is \code{FALSE}.}

\item{constraints}{an (optional) logical argument stating whether general linear constraints should be applied to the model. Default is \code{FALSE}.}
}
\value{
Throws an error if any check fails. Doesn't return anything.
}
\description{
\code{parameterChecks} checks dimension, restrictions, stationarity and identifibility of the given parameters
  of GMAR or StMAR model. Throws an error if any check fails.
}
\details{
Note that the "params" -parameter vector is assumed to be in the "standard" form for restricted models as well.
}
