% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalDifferentiation.R
\name{calc_gradient}
\alias{calc_gradient}
\alias{calc_hessian}
\alias{get_gradient}
\alias{get_foc}
\alias{get_hessian}
\alias{get_soc}
\title{Calculate gradient or Hessian matrix}
\usage{
calc_gradient(x, fn, h = 6e-06, varying_h = NULL, ...)

calc_hessian(x, fn, h = 6e-06, varying_h = NULL, ...)

get_gradient(gsmar, custom_h = NULL)

get_foc(gsmar, custom_h = NULL)

get_hessian(gsmar, custom_h = NULL)

get_soc(gsmar, custom_h = NULL)
}
\arguments{
\item{x}{a numeric vector specifying the point at which the gradient or Hessian should be evaluated.}

\item{fn}{a function that takes in the argument \code{x} as the \strong{first} argument.}

\item{h}{the difference used to approximate the derivatives.}

\item{varying_h}{a numeric vector with the same length as \code{x} specifying the difference \code{h}
for each dimension separately. If \code{NULL} (default), then the difference given as parameter \code{h}
will be used for all dimensions.}

\item{...}{other arguments passed to \code{fn}.}

\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{custom_h}{same as \code{varying_h} but if \code{NULL} (default), then the difference \code{h} used for differentiating
overly large degrees of freedom parameters is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other
parameters.}
}
\value{
The gradient functions return numerical approximation of the gradient, and the Hessian functions return
 numerical approximation of the Hessian. \code{get_soc} returns eigenvalues of the Hessian matrix, \code{get_foc}
 is the same as \code{get_gradient} but named conveniently.
}
\description{
\code{calc_gradient} or \code{calc_hessian} calculates the gradient or Hessian matrix
 of the given function at the given point using central difference numerical approximation.
 \code{get_gradient} (and \code{get_foc}) or \code{get_hessian} calculates the gradient or Hessian matrix of the
 log-likelihood function at the parameter values of a class \code{'gsmar'} object.
 \code{get_soc} returns eigenvalues of the Hessian matrix.
}
\details{
In particular, the functions \code{get_foc} and \code{get_soc} can be used to check whether
 the found estimates denote a (local) maximum point, a saddle point, or something else.
}
\section{Warning}{

 No argument checks!
}

\examples{
 # Simple function
 foo <- function(x) x^2 + x
 calc_gradient(x=1, fn=foo)
 calc_gradient(x=-0.5, fn=foo)
 calc_hessian(x=2, fn=foo)

 # More complicated function
 foo <- function(x, a, b) a*x[1]^2 - b*x[2]^2
 calc_gradient(x=c(1, 2), fn=foo, a=0.3, b=0.1)
 calc_hessian(x=c(1, 2), fn=foo, a=0.3, b=0.1)

 # GMAR model:
 params12 <- c(0.18281409, 0.92657275, 0.00214552,
  0.85725129, 0.68210294, 0.01900299, 0.88342018)
 gmar12 <- GSMAR(logVIX, 1, 2, params12)
 get_gradient(gmar12)
 get_foc(gmar12)
 get_hessian(gmar12)
 get_soc(gmar12)
}
\seealso{
\code{\link{profile_logliks}}
}
