% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{profile_logliks}
\alias{profile_logliks}
\title{Plot profile log-likehoods around the estimates}
\usage{
profile_logliks(gsmar, scale = 0.02, nrows, ncols, precission = 200)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{scale}{a numeric scalar specifying the interval plotted for each estimate: the estimate plus-minus \code{abs(scale*estimate)}.}

\item{nrows}{how many rows should be in the plot-matrix? The default is \code{max(ceiling(log2(nparams) - 1), 1)}.}

\item{ncols}{how many columns should be in the plot-matrix? The default is \code{ceiling(nparams/nrows)}.
Note that \code{nrows*ncols} should not be smaller than the number of parameters.}

\item{precission}{at how many points should each profile log-likelihood be evaluated at?}
}
\value{
Only plots to a graphical device and doesn't return anything.
}
\description{
\code{profile_logliks} plots profile log-likelihoods around the estimates.
}
\details{
The red vertical line points the estimate.

  Be aware that the profile log-likelihood function is subject to a numerical error due to limited float-point
  precission when considering extremely large parameter values, say, overly large degrees freedom estimates.
}
\examples{
\donttest{
# StMAR model
fit42 <- fitGSMAR(data=T10Y1Y, p=4, M=2, model="StMAR")
profile_logliks(fit42)

# Non-mixture version of StMAR model
fit101t <- fitGSMAR(T10Y1Y, 10, 1, model="StMAR", ncores=1, ncalls=1)
profile_logliks(fit101t)

# G-StMAR model
fit42g <- fitGSMAR(T10Y1Y, 4, M=c(1, 1), model="G-StMAR")
profile_logliks(fit42g)

# Two-regime GMAR p=2 model with the second AR coeffiecient of
# of the second regime contrained to zero.
constraints <- list(diag(1, ncol=2, nrow=2), as.matrix(c(1, 0)))
fit22c <- fitGSMAR(T10Y1Y, 2, 2, constraints=constraints)
profile_logliks(fit22c)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{quantileResidualPlot}}, \code{\link{diagnosticPlot}}, \code{\link{condmomentPlot}}, \code{\link{GSMAR}},
 \code{\link{quantileResidualTests}}, \code{\link{simulateGSMAR}}
}
