% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{uber_requests_estimate}
\alias{uber_requests_estimate}
\title{Request estimate}
\usage{
uber_requests_estimate(start_latitude = NULL, start_longitude = NULL,
  end_latitude = NULL, end_longitude = NULL)
}
\arguments{
\item{start_latitude}{Initial latitude.}

\item{start_longitude}{Initial longitude.}

\item{end_latitude}{Final latitude.}

\item{end_longitude}{Final longitude.}
}
\description{
Allows a ride to be estimated given the desired product, start, and end locations. If the end location is not provided, only the pickup ETA and details of surge pricing information are provided. If the pickup ETA is null, there are no cars available, but an estimate may still be given to the user.
}
\details{
Requires an OAuth 2.0 token with the request scope.
}
\examples{
\dontrun{
uber_requests_estimate(start_latitude = 37.761492, start_longitude = -122.423941,
                       end_latitude = 37.775393, end_longitude = -122.417546)
}
}
\references{
\url{https://developer.uber.com/docs/ride-requests/references/api/v1-requests-estimate-post}
}

