% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_set_guess}
\alias{system_set_guess}
\title{Alter Initial Guess and Parameter Bounds}
\usage{
system_set_guess(cfg, pname, value, lb = NULL, ub = NULL)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{pname}{name of parameter to set}

\item{value}{value to assign}

\item{lb}{optionally change the lower bound (\code{NULL})}

\item{ub}{optionally change the upper bound (\code{NULL})}
}
\value{
cfg ubiquity system object with guess and bounds assigned
}
\description{
Default values for parameters are taken from the \code{system.txt} file
either when the parameter was defined (\code{<P>}) or when it was reassigned
for a parameter set (\code{<PSET:?:?>?}). These can be altered at the
scripting level using this function.
}
\details{
When performing a parameter estimation, the initial guess will be the value
specified in the \code{system.txt} file for the currently selected parameter set. The
following command can be used after the parameter set has been selected to
specify the value (\code{VALUE}) of the parameter \code{PNAME} and optionally the lower (\code{lb})
and upper (\code{ub}) bounds:
\preformatted{cfg = system_set_guess(cfg, pname="PNAME", value=VALUE, lb=NULL, ub=NULL)}

To set the initial guess for the parameter Vc to a value of 3, the following
would be used:
\preformatted{cfg = system_set_guess(cfg, "Vc", value=3)}

To specify the guess and overwrite the upper bound on Vc and set it to 5
\preformatted{cfg = system_set_guess(cfg, "Vc", value=3, ub=5) }
}
