% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_biomarkers_user.R
\name{recompute_derived_biomarkers}
\alias{recompute_derived_biomarkers}
\title{Recompute composite biomarkers and ratios from the 107 non-derived biomarkers}
\usage{
recompute_derived_biomarkers(x)
}
\arguments{
\item{x}{\code{data.frame} containing NMR metabolomics data from UK Biobank.
May either be raw field data output by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
or data with column names corresponding to biomarkers listed in \code{\link{nmr_info}}.}
}
\value{
a \code{data.frame} with all composite biomarkers and ratios
  (re)computed from the 107 non-derived biomarkers (see \code{\link{nmr_info}}
  for details).
}
\description{
When adjusting biomarkers for unwanted biological covariates, it is desirable
to recompute composite biomarkers and ratios to ensure consistency in the
adjusted dataset. This function will compute all composite biomarkers and
ratios from their parts (see \code{\link{nmr_info}} for biomarker details).
}
\details{
If your UK Biobank project only has access to a subset of biomarkers, then
this function will only return the subset of ratios that can be computed from
the biomarker data provided.

All biomarkers in the input data are also returned alongside those computed
by this function.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
bio_qc <- recompute_derived_biomarkers(ukb_data)

}
\seealso{
\code{\link{nmr_info}} for list of computed biomarker ratios,
  \code{\link{recompute_derived_biomarker_qc_flags}()} for obtaining an
  aggregate of the biomarker QC flags from the biomarkers underlying each
  computed biomarker, and \code{\link{extract_biomarkers}()} for details on
  how the raw field data extracted by the Table Exporter tool is processed.
}
