% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\docType{data}
\name{umap.defaults}
\alias{umap.defaults}
\title{Default configuration for umap}
\format{An object of class \code{umap.config} of length 19.}
\usage{
umap.defaults
}
\description{
A list with parameters customizing a UMAP embedding. Each component of the
list is an effective argument for umap().
}
\details{
n.neighbors: integer; number of nearest neighbors

n.components: integer; dimension of target (output) space

metric.function: character or function; determines how distances between
data points are computed. When using a string, available metrics are:
euclidean, manhattan. Other availble generalized metrics are: cosine,
pearson, pearson2. Note the triangle inequality may not be satisfied by
some generalized metrics, hence knn search may not be optimal.
When using metric.function as a function, the signature must be
function(matrix) and should compute a distance between the first row
and all subsequent rows.

n.epochs: integer; number of iterations performed during
layout optimization

input: character, use either "data" or "dist"; determines whether the primary
input argument to umap() is treated as a data matrix or as a distance matrix

init: character or matrix. The default string "spectral" computes an initial
embedding using eigenvectors of the connectivity graph matrix. An alternative is
the string "random", which creates an initial layout based on random coordinates. 
This setting.can also be set to a matrix, in which case layout optimization
begins from the provided coordinates.

min.dist: numeric; determines how close points appear in the final layout

set.op.mix.ratio: numeric in range [0,1]; determines who the knn-graph
is used to create a fuzzy simplicial graph

local.connectivity: numeric; used during construction of fuzzy simplicial set

bandwidth: numeric; used during construction of fuzzy simplicial set

alpha: numeric; initial value of "learning rate" of layout optimization

beta: numeric; determines, together with alpha, the learning rate of layout optimization

negative.sample.rate: integer; determines how many non-neighbor points are
used per point and per iteration during layout optimization

a: numeric; contributes to gradient calculations during layout optimization.
When left at NA, a suitable value will be estimated automatically.

b: numeric; contributes to gradient calculationss during layout optimization.

spread: numeric; used during automatic estimation of a/b parameters.

seed: integer; seed for random number generation

knn.repeat: number of times to restart knn search

verbose: logical or integer; determines whether to show progress messages
}
\examples{
# display all default settings
umap.defaults

# create a new settings object with n.neighbors set to 5
custom.settings = umap.defaults
custom.settings$n.neighbors = 5
custom.settings

}
\keyword{datasets}
