% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_make_MR_data}
\alias{umx_make_MR_data}
\title{Simulate Mendelian Randomization data}
\usage{
umx_make_MR_data(nSubjects = 1000, Vqtl = 0.02, bXY = 0.1, bUX = 0.5,
  bUY = 0.5, pQTL = 0.5, seed = 123)
}
\arguments{
\item{nSubjects}{Number of subjects in sample}

\item{Vqtl}{Variance of QTL affecting causal variable X (Default 0.02)}

\item{bXY}{Causal effect of X on Y (Default 0.1)}

\item{bUX}{Confounding effect of confounder 'U' on X (Default 0.5)}

\item{bUY}{Confounding effect of confounder 'U' on Y (Default 0.5)}

\item{pQTL}{Decreaser allele frequency (Default 0.5)}

\item{seed}{value for the random number generator (Default 123)}
}
\value{
- data.frame
}
\description{
umx_make_MR_data returns a dataset containing 4 variables: A variable of interest (Y), a putative cause (X),
a qtl (quantitative trait locus) influencing X, and a confounding variable (U) affecting both X and Y.
}
\details{
The code to make these Data. Modified from Dave Evans 2016 Boulder workshop talk.
}
\examples{
df = umx_make_MR_data(10000)
str(df)
\dontrun{
m1 = umxTwoStage(Y ~ X, ~qtl, data = df)
plot(m1)
}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}
