% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_set_auto_run}
\alias{umx_set_auto_run}
\title{umx_set_auto_run}
\usage{
umx_set_auto_run(autoRun = NA, silent = FALSE)
}
\arguments{
\item{autoRun}{If TRUE or FALSE, sets the umx_auto_run option. Else returns the current value of umx_auto_run}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
- Current umx_auto_run setting
}
\description{
Set autoRun default for models like umxACE umxGxE etc.
}
\examples{
library(umx)
umx_set_auto_run() # print existing value
old = umx_set_auto_run(silent = TRUE) # store existing value
umx_set_auto_run(FALSE)  # set to FALSE
umx_set_auto_run(old)    # reinstate
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Get and set: \code{\link{umx_default_option}},
  \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_options}},
  \code{\link{umx_set_auto_plot}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_condensed_slots}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimizer}},
  \code{\link{umx_set_plot_file_suffix}},
  \code{\link{umx_set_plot_format}},
  \code{\link{umx_set_table_format}}, \code{\link{umx}}
}
