% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_high_level_models.r
\name{umxEFA}
\alias{umxEFA}
\alias{umxFactanal}
\title{FIML-based Exploratory Factor Analysis (EFA)}
\usage{
umxEFA(x = NULL, factors = NULL, data = NULL, n.obs = NULL,
  scores = c("none", "ML", "WeightedML", "Regression"),
  minManifests = NA, rotation = c("varimax", "promax", "none"),
  name = "efa", digits = 2, return = c("model", "loadings"),
  report = c("markdown", "html"), covmat = NULL)
}
\arguments{
\item{x}{Either 1: data, 2: A formula (not implemented yet), 3: A vector of variable names, or 4: A name for the model.}

\item{factors}{Either number of factors to request or a vector of factor names.}

\item{data}{A dataframe of manifest columns you are modeling}

\item{n.obs}{Number of observations in covmat (if provided, default = NA)}

\item{scores}{Type of scores to produce, if any. The default is none, "Regression" gives Thompson's scores. Other options are 'ML', 'WeightedML', Partial matching allows these names to be abbreviated.}

\item{minManifests}{The least number of variables required to return a score for a participant (Default = NA).}

\item{rotation}{A rotation to perform on the loadings (default  = "varimax" (orthogonal))}

\item{name}{A name for your model}

\item{digits}{rounding (default = 2)}

\item{return}{by default, the resulting MxModel is returned. Say "loadings" to get a fact.anal object.}

\item{report}{Report as markdown to the console, or open a table in browser ("html")}

\item{covmat}{Covariance matrix of data you are modeling (not implemented)}
}
\value{
- EFA \code{\link{mxModel}}
}
\description{
Perform full-information maximum-likelihood factor analysis on a data matrix.
}
\details{
As in \code{\link{factanal}}, you need only specify the number of factors and offer up
some manifest data, e.g:
                                                             
\code{umxEFA(factors = 2, data = mtcars)}

Equivalently, you can also give a list of factor names:

\code{umxEFA(factors = c("g", "v"), data = mtcars)}

The factor model is implemented as a structural equation model, e.g.

\figure{umxEFA.png}

You can request \code{scores} from the model. Unlike factanal, these can cope with missing data.

You can also rotate the factors using any rotation function.


In an EFA, all items may load on all factors.

For identification we need m^2 degrees of freedom. We get m * (m+1)/2 from fixing factor variances to 1 and covariances to 0.
We get another m(m-1)/2 degrees of freedom by fixing the upper-right hand corner of the factor loadings
component of the A matrix. The manifest variances are also lbounded at 0.

EFA reports standardized loadings: to do this, we scale the data.

\emph{note}: Bear in mind that factor scores are indeterminate.

Thanks to @ConorDolan for code implementing the rotation matrix and other suggestions!
}
\examples{
\dontrun{
myVars <- c("mpg", "disp", "hp", "wt", "qsec")
m1 = umxEFA(mtcars[, myVars], factors =   2, rotation = "promax")
loadings(m1)

# Formula interface in base-R factanal()
m2 = factanal(~ mpg + disp + hp + wt + qsec, factors = 2, rotation = "promax", data = mtcars)
loadings(m2)
plot(m2)

# Return a loadings object
x = umxEFA(mtcars[, myVars], factors = 2, return = "loadings")
names(x)

m1 = umxEFA(myVars, factors = 2, data = mtcars, rotation = "promax")
m1 = umxEFA(name = "named", factors = "g", data = mtcars[, myVars])
m1 = umxEFA(name = "by_number", factors = 2, rotation = "promax", data = mtcars[, myVars])
x = umxEFA(name = "score", factors = "g", data = mtcars[, myVars], scores= "Regression")
}
}
\references{
- \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{factanal}}, \code{\link{mxFactorScores}}

Other Super-easy helpers: \code{\link{umxTwoStage}},
  \code{\link{umx}}
}
\concept{Super-easy helpers}
