% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_score_scale}
\alias{umx_score_scale}
\title{Score a scale by summing normal and reversed items}
\usage{
umx_score_scale(base = NULL, pos = NULL, rev = NULL, min = 1,
  max = NULL, data = NULL, score = c("sum", "mean"), name = NULL)
}
\arguments{
\item{base}{String common to all item names.}

\item{pos}{The positive-scored item numbers.}

\item{rev}{The reverse-scored item numbers.}

\item{min}{Min possible score (default = 1). Not implemented for values other than 1 so far...}

\item{max}{Max possible score for an item (to compute how to reverse items).}

\item{data}{The data frame}

\item{score}{= Sum or Mean (default = "sum")}

\item{name}{= name of the scale to be returned. Defaults to "<base>_score"}
}
\value{
\itemize{
\item scores
}
}
\description{
Score a scale by summing normal and reversed items. \code{base} is the string common to all item names.
pos and rev are the normal and reverse-scored item numbers. \code{itemMax} is the high score (to compute how to reverse items).
}
\examples{
library(psych)
tmp = umx_score_scale("A", pos = 1:3, rev = 4:5, max = 6, data= bfi, name = "A")
tmp = umx_score_scale("E", pos = c(3,4,5), rev = c(1,2), max = 6, data= bfi, name = "E")

# Using @BillRevelle's psych package: More diagnostics.
scores= psych::scoreItems(list(E= c("-E1","-E2","E3","E4","E5")), bfi, min = 1, max = 6)
summary(scores)
print(scores)

# Compare output (note, scoreItems replaces NAs with the sample median by default...)
all(as.numeric(scores$scores)*5 ==tmp[,"E"], na.rm = TRUE)

}
\seealso{
Other Miscellaneous Utility Functions: \code{\link{install.OpenMx}},
  \code{\link{qm}}, \code{\link{umxBrownie}},
  \code{\link{umxFactor}}, \code{\link{umxVersion}},
  \code{\link{umx_array_shift}},
  \code{\link{umx_cell_is_on}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_find_object}},
  \code{\link{umx_graphviz_rank}}, \code{\link{umx_make}},
  \code{\link{umx_mat2dot}}, \code{\link{umx_msg}},
  \code{\link{umx_open_CRAN_page}}, \code{\link{umx_pad}},
  \code{\link{umx_pb_note}}, \code{\link{umx_print}},
  \code{\link{umx_scale}}, \code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
