% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_make_mxData}
\alias{xmu_make_mxData}
\title{Upgrade a dataframe to an mxData type.}
\usage{
xmu_make_mxData(data = NULL, type = c("Auto", "FIML", "cov", "cor",
  "WLS", "DWLS", "ULS"), manifests = NULL,
  allContinuousMethod = c("cumulants", "marginals"), verbose = FALSE)
}
\arguments{
\item{data}{A \code{\link{data.frame}} or \code{\link{mxData}}}

\item{type}{What data type is wanted out c("Auto", "FIML", "cov", "cor", 'WLS', 'DWLS', 'ULS')}

\item{manifests}{If set, only these variables will be retained.}

\item{allContinuousMethod}{passed for all continuous data c("cumulants", "marginals")}

\item{verbose}{If verbose, report on columns kept and dropped (default FALSE)}
}
\value{
- \code{\link{mxData}}
}
\description{
Non-user function to upgrade a dataframe to an mxData type. It can also trim variables.

The most common use will be to give it a dataframe, and get back an mxData object of type WLS, cov, cor, or raw.
}
\examples{
manVars = c("mpg", "cyl", "disp")
tmp = xmu_make_mxData(data= mtcars, type = "Auto")
tmp = xmu_make_mxData(data= mtcars, type = "Auto", manifests = manVars)
tmp = xmu_make_mxData(data= mtcars, type = "WLS" , manifests = manVars, verbose= TRUE)

# missing data WLS example
tmp = mtcars; tmp[1, "mpg"] = NA # add NA
tmp = xmu_make_mxData(data= tmp, type = "WLS", manifests = manVars, verbose= TRUE)
tmp = xmu_make_mxData(data= mtcars, type = "cov")
tmp = xmu_make_mxData(data= mtcars, type = "cor")
# pass string through
xmu_make_mxData(data= c("a", "b", "c"), type = "Auto")

}
\seealso{
Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_assemble_twin_supermodel}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_make_top_twin_models}},
  \code{\link{xmu_safe_run_summary}},
  \code{\link{xmu_set_sep_from_suffix}},
  \code{\link{xmu_simplex_corner}},
  \code{\link{xmu_start_value_list}},
  \code{\link{xmu_starts}}
}
\concept{xmu internal not for end user}
