% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxDiagnose}
\alias{umxDiagnose}
\title{Diagnose problems in a model - this is a work in progress.}
\usage{
umxDiagnose(model, tryHard = FALSE, diagonalizeExpCov = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to diagnose}

\item{tryHard}{whether I should try and fix it? (defaults to FALSE)}

\item{diagonalizeExpCov}{Whether to diagonalize the ExpCov}
}
\value{
- helpful messages and perhaps a modified model
}
\description{
The goal of this function is to diagnose problems in a model and return suggestions to the user.
It is a work in progress, and probably is not of any use as yet.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("OneFactor", data = myData,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m1 = mxRun(m1)
umxSummary(m1, show = "std")
umxDiagnose(m1)
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\concept{Teaching and Testing functions}
