% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxDiagnose}
\alias{umxDiagnose}
\title{Diagnose problems in a model - this is a work in progress.}
\usage{
umxDiagnose(model, tryHard = FALSE, diagonalizeExpCov = FALSE)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to diagnose}

\item{tryHard}{whether I should try and fix it? (defaults to FALSE)}

\item{diagonalizeExpCov}{Whether to diagonalize the ExpCov}
}
\value{
\itemize{
\item helpful messages and perhaps a modified model
}
}
\description{
The goal of this function \strong{WILL BE} (not currently functional) to diagnose problems in
a model and return suggestions to the user.
It is a work in progress, and of no use as yet.
}
\details{
Best diagnostics are:
\enumerate{
\item Observed data variances and means
\item Expected variances and means
\item Difference of these?
}

Try
* diagonalizeExpCov diagonal
* \code{\link[=umx_is_ordered]{umx_is_ordered()}}\preformatted{more tricky - we should really report the variances and the standardized thresholds.
}

The guidance would be to try starting with unit variances and thresholds that are within
+/- 2 SD of the mean. \href{https://openmx.ssri.psu.edu/thread/3899}{bivariate outliers \%p option}
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)

m1 = umxRAM("OneFactor", data = demoOneFactor, type= "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1)
)
m1 = mxRun(m1)
umxSummary(m1, std = TRUE)
umxDiagnose(m1)
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Teaching and Testing functions: 
\code{\link{tmx_show.MxModel}()},
\code{\link{umxPower}()}
}
\concept{Teaching and Testing functions}
