% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxReduceGxE}
\alias{umxReduceGxE}
\title{Reduce a GxE model.}
\usage{
umxReduceGxE(
  model,
  report = c("markdown", "inline", "html", "report"),
  intervals = TRUE,
  baseFileName = "tmp_gxe",
  tryHard = c("yes", "no", "ordinal", "search"),
  silent = FALSE,
  ...
)
}
\arguments{
\item{model}{A \code{\link[=umxGxE]{umxGxE()}} to reduce.}

\item{report}{How to report the results. default = "markdown". "html" = open in browser.}

\item{intervals}{Recompute CIs (if any included) on the best model (default = TRUE)}

\item{baseFileName}{(optional) custom filename for html output (default = "tmp").}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{silent}{Default (FALSE)}

\item{...}{Other parameters to control model summary.}
}
\value{
best model
}
\description{
This function can perform model reduction for \code{\link[=umxGxE]{umxGxE()}} models,
testing dropping a\verb{,c} & e\verb{, as well as c & c}, a & a` etc.

It reports the results in a table. Set the format of the table with
\code{\link[=umx_set_table_format]{umx_set_table_format()}}. Or set \code{report = "html"} to open a
table for pasting into a word processor.

In addition to printing a table, the function returns the preferred model.
}
\examples{
\dontrun{
model = umxReduce(model)
}
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights.
\emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \doi{10.3758/BF03206482}.
}
}
\seealso{
\code{\link[=umxReduce]{umxReduce()}}, \code{\link[=umxReduceACE]{umxReduceACE()}}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
