% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxGxEbiv.R
\name{umxPlotGxEbiv}
\alias{umxPlotGxEbiv}
\alias{plot.MxModelGxEbiv}
\title{Plot the results of a GxE univariate test for moderation of ACE components.}
\usage{
umxPlotGxEbiv(x, xlab = NA, location = "topleft", separateGraphs = FALSE, ...)
}
\arguments{
\item{x}{A fitted \code{\link[=umxGxEbiv]{umxGxEbiv()}} model to plot}

\item{xlab}{String to use for the x label (default = NA, which will use the variable name)}

\item{location}{Where to plot the legend (default = "topleft")
see ?legend for alternatives like bottomright}

\item{separateGraphs}{(default = FALSE)}

\item{...}{Optional additional parameters}
}
\value{
None
}
\description{
Plot GxE results (univariate environmental moderation of ACE components).
Options include plotting the raw and standardized graphs separately, or in a combined panel.
You can also set the label for the x axis (xlab), and choose the location of the legend.
}
\examples{
require(umx)
data(twinData)
\dontrun{
selDVs  = "wt"; selDefs = "ht"
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), suffix = "")
mzData  = subset(df, zygosity \%in\%  c("MZFF", "MZMM"))
dzData  = subset(df, zygosity \%in\%  c("DZFF", "DZMM", "DZOS"))

m1 = umxGxEbiv(selDVs = selDVs, selDefs = selDefs, 
	dzData = dzData, mzData = mzData, sep = "", dropMissingDef = TRUE)
# Plot Moderation
plot(m1)
umxPlotGxEbiv(m1, xlab = "wt", separateGraphs = TRUE, location = "topleft")
}
}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxGxEbiv]{umxGxEbiv()}}
}

Other Plotting functions: 
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umxPlot}()},
\code{\link{umx}}
}
\concept{Plotting functions}
