% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_pad}
\alias{umx_pad}
\title{Pad an Object with NAs}
\usage{
umx_pad(x, n)
}
\arguments{
\item{x}{An \R object (list, data.frame, matrix, atomic vector).}

\item{n}{The final length of each object.}
}
\value{
- padded object
}
\description{
This function pads an R object (list, data.frame, matrix, atomic vector)
with \code{NA}s. For matrices, lists and data.frames, this occurs by extending
each (column) vector in the object.
}
\examples{
umx_pad(1:3, 4)
umx_pad(1:3, 3)
}
\references{
- \url{https://github.com/kevinushey/Kmisc/tree/master/man}
}
\seealso{
Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umx}},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_print}()}
}
\concept{Miscellaneous Utility Functions}
