% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid.R
\name{planarSection}
\alias{planarSection}
\title{Sphere planar sections}
\usage{
planarSection(S, d, intern = FALSE, pl = 0)
}
\arguments{
\item{S}{list of spheres of class \code{sphere}, see \code{\link{simPoissonSystem}}}

\item{d}{distance of the (planar) xy-plane to the origin}

\item{intern}{logical, \code{FALSE} (default), whether to return all discs or
only those which have their centers inside the intersecting window}

\item{pl}{print level, \code{pl>0} for some verbose output}
}
\value{
numeric vector of disc diameters
}
\description{
Planar intersection of spheres
}
\details{
The function computes the planar intersection of a sphere system, i.e. an intersection with the plane whose normal
vector is given by \code{c(0,0,1)} and returns the diameters of the resulting discs.
}
\examples{
 lam <- 100
 
 # parameter rlnorm distribution (radii)
 theta <- list("size"=list("meanlog"=-2.5,"sdlog"=0.5))
 
 # simulation bounding box
 box <- list("xrange"=c(0,5),"yrange"=c(0,5),"zrange"=c(0,5))
 
 # simulate only 3D system
 S <- simPoissonSystem(theta,lam,size="rlnorm",box=box,type="spheres",
   intersect="original", pl=1)
 
 # return only objects whose centers are within
 # the intersection window
 sp <- planarSection(S,d=2.5,intern=TRUE,pl=1)
 
 # histogram of diameters
 hist(sp)
 summary(sp)
 
 # distribution of radii
 mean(log(sp/2))
 sd(log(sp/2))


}
\author{
M. Baaske
}
