% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbreak_rows.R
\name{unbreak_rows}
\alias{unbreak_rows}
\title{Merge rows up}
\usage{
unbreak_rows(df, regex, ogcol, sep = " ")
}
\arguments{
\item{df}{A data frame with at least two contiguous rows to be merged.}

\item{regex}{A regular expression to identify sets of rows to be merged,
meant for the leading of the two contiguous rows.}

\item{ogcol}{Variable with the text strings to match.}

\item{sep}{Character string to separate the unified values (default is
space).}
}
\value{
A tibble or data frame with merged rows. Values of the
  lagging rows are pasted onto the values in the leading row, whitespace is
  squished, and the lagging row is dropped.
}
\description{
Merge rows up
}
\examples{
bball <-
  data.frame(
    stringsAsFactors = FALSE,
    v1 = c(
      "Player", NA, "Sleve McDichael", "Dean Wesrey",
      "Karl Dandleton"
    ),
    v2 = c("Most points", "in a game", "55", "43", "41"),
    v3 = c("Season", "(year ending)", "2001", "2000", "2010")
  )
unbreak_rows(bball, "Most", v2)
}
