% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stanford.R
\docType{data}
\name{stanford_2_accent}
\alias{stanford_2_accent}
\title{Accent colors of Stanford University}
\format{
An object of class \code{character} of length 42.
}
\source{
Color definitions are based on the
\href{https://identity.stanford.edu/design-elements/color/}{Color manual}.
}
\usage{
stanford_2_accent
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stanford_2_accent} provides the 42 accent colors
of the \href{https://www.stanford.edu/}{Stanford University}, USA.
}
\details{
Although our primary palette should drive most Stanford communications materials, other colors can be added as appropriate.
For those circumstances, we have developed this accent palette.

These colors are intended to compliment our Stanford primary colors: 
\code{"palo_alto"} (defined as HEX #175E54),
\code{"palo_alto_light"} (defined as HEX #2D716F),
\code{"palo_alto_dark"} (defined as HEX #014240),
\code{"palo_verde"} (defined as HEX #279989),
\code{"palo_verde_light"} (defined as HEX #59B3A9),
\code{"palo_verde_dark"} (defined as HEX #017E7C),
\code{"olive"} (defined as HEX #8F993E),
\code{"olive_light"} (defined as HEX #A6B168),
\code{"olive_dark"} (defined as HEX #7A863B),
\code{"bay"} (defined as HEX #6FA287),
\code{"bay_light"} (defined as HEX #8AB8A7),
\code{"bay_dark"} (defined as HEX #417865),
\code{"sky"} (defined as HEX #4298B5),
\code{"sky_light"} (defined as HEX #67AFD2),
\code{"sky_dark"} (defined as HEX #016895),
\code{"lagunita"} (defined as HEX #007C92),
\code{"lagunita_light"} (defined as HEX #009AB4),
\code{"lagunita_dark"} (defined as HEX #006B81),
\code{"poppy"} (defined as HEX #E98300),
\code{"poppy_light"} (defined as HEX #F9A44A),
\code{"poppy_dark"} (defined as HEX #D1660F),
\code{"spirited"} (defined as HEX #E04F39),
\code{"spirited_light"} (defined as HEX #F4795B),
\code{"spirited_dark"} (defined as HEX #C74632),
\code{"illuminating"} (defined as HEX #FEDD5C),
\code{"illuminating_light"} (defined as HEX #FFE781),
\code{"illuminating_dark"} (defined as HEX #FEC51D),
\code{"plum"} (defined as HEX #620059),
\code{"plum_light"} (defined as HEX #734675),
\code{"plum_dark"} (defined as HEX #350D36),
\code{"brick"} (defined as HEX #651C32),
\code{"brick_light"} (defined as HEX #7F2D48),
\code{"brick_dark"} (defined as HEX #42081B),
\code{"archway"} (defined as HEX #5D4B3C),
\code{"archway_light"} (defined as HEX #766253),
\code{"archway_dark"} (defined as HEX #2F2424),
\code{"stone"} (defined as HEX #7F7776),
\code{"stone_light"} (defined as HEX #D4D1D1),
\code{"stone_dark"} (defined as HEX #544948),
\code{"fog"} (defined as HEX #DAD7CB),
\code{"fog_light"} (defined as HEX #F4F4F4) and
\code{"fog_dark"} (defined as HEX #B6B1A9)
}
\examples{
stanford_2_accent
unikn::seecol(stanford_2_accent, main = "Accent colors Stanford Uni") # view color palette

}
\seealso{
\code{\link{stanford_1}} for primary colors of Stanford University;
\code{\link{stanford_3_web}} for web colors of Stanford University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCSD_1_core}},
\code{\link{UCSD_2_accent}},
\code{\link{UCSD_3_neutral}},
\code{\link{asu_1}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{birmingham_1}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu_1}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{carleton_1}},
\code{\link{chicago_1}},
\code{\link{chicago_2}},
\code{\link{columbia}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh_1}},
\code{\link{eth_1}},
\code{\link{eth_2}},
\code{\link{eth_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{guelph}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{laval}},
\code{\link{limerick_1}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_2}},
\code{\link{mit_pal}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{mpg_pal}},
\code{\link{msu_pal}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ottawa_1}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{queens_1}},
\code{\link{queens_2}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{sfu_brand}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stanford_1}},
\code{\link{stanford_3_web}},
\code{\link{toronto_1}},
\code{\link{trinity_1}},
\code{\link{ubc_1}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_primary}},
\code{\link{ucalgary_secondary}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uci_1}},
\code{\link{uflorida_1}},
\code{\link{umass_2}},
\code{\link{umass_brand}},
\code{\link{umass_neutrals}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg_1}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_manchester_1}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_2_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_3}},
\code{\link{waikato}},
\code{\link{western_uni_1}},
\code{\link{yale_1}},
\code{\link{yeshiva}},
\code{\link{york1}},
\code{\link{york2}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{university color palettes}
\keyword{datasets}
