## Oxford.R | 2023 08 24
## Colours of University of Oxford, England/UK
## -------------------------------------------

# Information: ------

# cur_pals: "oxford_brand", "oxford_general", "oxford_link", "oxford_shades", "oxford_blog", "oxford_graduate", "oxford_error", "oxford_socialmedia" (8)
# inst: "Oxford University"
# inst_alt: "University of Oxford"
# country: England/UK
# URL: "https://www.ox.ac.uk/"

# Colour source:

# URL: <https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide>
# Last check: 2023-06-15


# Colours: ------ 


# Brand colours: 
#
# Primary: #002147
col_brand_1 <- "#002147"
name_brand_1 <- "primary"
#
# Secondary: #a79d96
col_brand_2 <- "#a79d96"
name_brand_2 <- "secondary"
#
# Tertiary: #f3f1ee
col_brand_3 <- "#f3f1ee"
name_brand_3 <- "tertiary"
#
# Light Primary: #122f53
col_brand_4 <- "#122f53"
name_brand_4 <- "light_primary"


# General/secondary colours: 
#
# Dark Blue: #001c3d
col_general_1 <- "#001c3d"
name_general_1 <- "dark_blue"
#
# Washed out blue: #193658
col_general_2 <- "#193658"
name_general_2 <- "washed_out_blue"
#
# Copyright Grey: #c7c2bc
col_general_3 <- "#c7c2bc"
name_general_3 <- "copyright_grey"
#
# Beige grey: #f3f1ec
col_general_4 <- "#f3f1ec"
name_general_4 <- "beige_grey"
#
# Brown grey: #001c3d
col_general_5 <- "#001c3d"
name_general_5 <- "brown_grey"
# 
# Filter form green: #043946
col_general_6 <- "#043946"
name_general_6 <- "filter_form_green"
#
# Blue grey: #a1c4d0
col_general_7 <- "#a1c4d0"
name_general_7 <- "blue_grey"
# 
# Teal: #003947 
col_general_8 <- "#003947"
name_general_8 <- "teal"
#
# Very light blue: #f0f5f8
col_general_9 <- "#f0f5f8"
name_general_9 <- "very_light_blue"
#
# Cookie bar: #00152e
col_general_10 <- "#00152e"
name_general_10 <- "cookie_bar"
#
# Blue grey: #353c47
col_general_11 <- "#353c47"
name_general_11 <- "blue_grey"


# Link colours: 
#
# Link: #3277ae
col_link_1 <- "#3277ae"
name_link_1 <- "link"
#
# Link Hover: #44687d
col_link_2 <- "#44687d"
name_link_2 <- "link_hover"
#
# Alt Link Hover: #be0f34
col_link_3 <- "#be0f34"
name_link_3 <- "alt_link_hover"
#
# Link Header: #70a9d6
col_link_4 <- "#70a9d6"
name_link_4 <- "link_header"
#
# Link Overlay: #98c1e1
col_link_5 <- "#98c1e1"
name_link_5 <- "link_overlay"


# Shades: 
#
# Black: #000000
col_shades_1 <- "#000000"
name_shades_1 <- "black"
#
# Off Black: #333333
col_shades_2 <- "#333333"
name_shades_2 <- "off_black"
#
# Mid Grey: #7a736e
col_shades_3 <- "#7a736e"
name_shades_3 <- "mid_grey"
#
# Dark Grey: #a6a6a6
col_shades_4 <- "#a6a6a6"
name_shades_4 <- "dark_grey"
#
# Light Grey: #e0ded9
col_shades_5 <- "#e0ded9"
name_shades_5 <- "light_grey"
#
# Light Grey: #f9f8f5
col_shades_6 <- "#f9f8f5"
name_shades_6 <- "light_grey"
#
# White: #ffffff
col_shades_7 <- "#ffffff"
name_shades_7 <- "white"


# Custom blog colours: 
#
# Science Blog: #0f7361
col_blog_1 <- "#0f7361"
name_blog_1 <- "science_blog"
#
# Science blog button: #09332b
col_blog_2 <- "#09332b"
name_blog_2 <- "science_blog_button"
#
# Arts Blog: #721627
col_blog_3 <- "#721627"
name_blog_3 <- "arts_blog"
#
# Arts blog button: #330d14
col_blog_4 <- "#330d14"
name_blog_4 <- "arts_blog_button"
#
# Books Blog: #cf7a30
col_blog_5 <- "#cf7a30"
name_blog_5 <- "books_blog"
#
# Books blog button: #9c4700 
col_blog_6 <- "#9c4700"
name_blog_6 <- "books_blog_button"


# Graduate Country page colours: 
#
# Graduate light blue: #9eceeb
col_graduate_1 <- "#9eceeb"
name_graduate_1 <- "graduate_light_blue"
#
# Graduate blue: #5f9baf
col_graduate_2 <- "#5f9baf"
name_graduate_2 <- "graduate_blue"
#
# Graduate Navy blue: #44687d
col_graduate_3 <- "#44687d"
name_graduate_3 <- "graduate_navy_blue"
#
# Graduate grey blue: #a1c4d0 
col_graduate_4 <- "#a1c4d0"
name_graduate_4 <- "graduate_grey_blue"
#
# Graduate dark green: #69913b
col_graduate_5 <- "#69913b"
name_graduate_5 <- "graduate_dark_green"
#
# Graduate light green: #aab300
col_graduate_6 <- "#aab300"
name_graduate_6 <- "graduate_light_green"
#
# Graduate orange: #cf7a30
col_graduate_7 <- "#cf7a30"
name_graduate_7 <- "graduate_orange"
#
# Graduate yellow: #f5cf47
col_graduate_8 <- "#f5cf47"
name_graduate_8 <- "graduate_yellow"
#
# Graduate dark red: #872434
col_graduate_9 <- "#872434"
name_graduate_9 <- "graduate_dark_red"
#
# Graduate red: #be0f34
col_graduate_10 <- "#be0f34"
name_graduate_10 <- "graduate_red"
#
# Graduate pink #ebc4cb
col_graduate_11 <- "#ebc4cb"
name_graduate_11 <- "graduate_pink"
#
# Graduate grey: #a79d96
col_graduate_12 <- "#a79d96"
name_graduate_12 <- "graduate_grey"


# Error colours: 
#
# Status: #7dbc23
col_error_1 <- "#7dbc23"
name_error_1 <- "status"
#
# Warning: #bc9a23
col_error_2 <- "#bc9a23"
name_error_2 <- "warning"
#
# Error: #be0f34
col_error_3 <- "#be0f34"
name_error_3 <- "error"
#
# Error Light: #fff0f3
col_error_4 <- "#fff0f3"
name_error_4 <- "error_light"


# Social Media colours: 
#
# Cherry: #be0f34
col_socialmedia_1 <- "#be0f34"
name_socialmedia_1 <- "cherry"
#
# Purple: #ac48bf
col_socialmedia_2 <- "#ac48bf"
name_socialmedia_2 <- "purple"
#
# Red: #c7302b
col_socialmedia_3 <- "#c7302b"
name_socialmedia_3 <- "red"
#
# Light Blue: #1daced
col_socialmedia_4 <- "#1daced"
name_socialmedia_4 <- "light_blue"
#
# Deep blue: #001c3d
col_socialmedia_5 <- "#001c3d"
name_socialmedia_5 <- "deep_blue"
#
# Lagoon blue: #006599
col_socialmedia_6 <- "#006599"
name_socialmedia_6 <- "lagoon_blue"
#
# Weibo: #d62a2a
col_socialmedia_7 <- "#d62a2a"
name_socialmedia_7 <- "weibo"
#
# Green: #177770
col_socialmedia_8 <- "#177770"
name_socialmedia_8 <- "green"
#
# Orange: #fb8113
col_socialmedia_9 <- "#fb8113"
name_socialmedia_9 <- "orange"
#
# Google plus: #d34836
col_socialmedia_10 <- "#d34836"
name_socialmedia_10 <- "google_plus"
#
# Instagram: #517fa4
col_socialmedia_11 <- "#517fa4"
name_socialmedia_11 <- "instagram"


# Colour palette(s):

# - oxford_brand: Brand colours of Oxford University ------

#' Brand colours of University of Oxford, England, UK 
#'
#' \code{oxford_brand} provides the four brand colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#' 
#' The (dark) Oxford blue is used primarily in general page furniture 
#' such as the backgrounds on the header and footer.
#' This makes for a strong brand presence throughout the site. 
#' Because it features so strongly in these areas, 
#' it is not recommended to use it in large areas elsewhere. 
#' However it is used more sparingly in smaller elements 
#' such as in event date icons and search/filtering bars.
#'
#' The brand colours are
#' \code{"primary"} (defined as HEX #002147),
#' \code{"secondary"} (defined as HEX #a79d96),
#' \code{"tertiary"} (defined as HEX #f3f1ee), and
#' \code{"light_primary"} (defined as HEX #122f53).
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_brand
#' unikn::seecol(oxford_brand, main = "Uni Oxford brand colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_brand <- unikn::newpal(col = c(col_brand_1, col_brand_2, col_brand_3, col_brand_4),
                              names = c(name_brand_1, name_brand_2, name_brand_3, name_brand_4),
                              as_df = FALSE)

# # Check: 
# unikn::seecol(oxford_brand, main = "Brand colours of University of Oxford", col_bg = "lightgrey")



# - oxford_general: General/Secondary colours of Oxford University ------

#' General colours of University of Oxford, England, UK 
#'
#' \code{oxford_general} provides the general/ secondary colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#' 
#' The wide secondary palette is used to add visual distinction and texture 
#' to design elements as well as signifying page links, 
#' call-to-actions (e.g buttons) and active pages in navigational elements.
#'
#' The colours are
#' \code{"dark_blue"} (defined as HEX #001c3d),
#' \code{"washed_out_blue"} (defined as HEX #193658),
#' \code{"copyright_grey"} (defined as HEX #c7c2bc),
#' \code{"beige_grey"} (defined as HEX #f3f1ec),
#' \code{"brown_grey"} (defined as HEX #001c3d),
#' \code{"filter_form_green"} (defined as HEX #043946),
#' \code{"blue_grey"} (defined as HEX #a1c4d0),
#' \code{"teal"} (defined as HEX #003947),
#' \code{"very_light_blue"} (defined as HEX #f0f5f8),
#' \code{"cookie_bar"} (defined as HEX #00152e), and
#' \code{"blue_grey"} (defined as HEX #353c47).
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_general
#' unikn::seecol(oxford_general, main = "Uni Oxford general colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_general <- unikn::newpal(col = c(col_general_1, col_general_2, col_general_3, col_general_4, col_general_5, col_general_6, col_general_7, col_general_8, col_general_9, col_general_10, col_general_11),
                                names = c(name_general_1, name_general_2, name_general_3, name_general_4, name_general_5, name_general_6, name_general_7, name_general_8, name_general_9, name_general_10, name_general_11),
                                as_df = FALSE)

# # Check: 
# unikn::seecol(oxford_general, main = "General colours of University of Oxford", col_bg = "lightgrey")



# - oxford_link: Link colours of Oxford University ------

#' Link colours of University of Oxford, England, UK
#'
#' \code{oxford_link} provides the link colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#' 
#' Light blue is used to indicate general actions (links and buttons). 
#' Hence, it is also used in various navigational elements such as the block rollover effect 
#' on the drop down menus. 
#' However, many ever-present navigational links do not use this light blue link colour 
#' so as not to distract from the main page content and more contextual related links in the sidebar.
#' A distinctive red colour is used sparingly to highlight key/primary call to actions
#' This is to give it more visibility over other actions on the page of less importance.
#'
#' The colours are
#' \code{"link"} (defined as HEX #3277ae),
#' \code{"link hover"} (defined as HEX #44687d),
#' \code{"alt_link_hover"} (defined as HEX #be0f34),
#' \code{"link_header"} (defined as HEX #70a9d6) and
#' \code{"link_overlay"} (defined as HEX #98c1e1),
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_link
#' unikn::seecol(oxford_link, main = "Uni Oxford link colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_link <- unikn::newpal(col = c(col_link_1, col_link_2, col_link_3, col_link_4, col_link_5),
                             names = c(name_link_1, name_link_2, name_link_3, name_link_4, name_link_5),
                             as_df = FALSE)

# # Check: 
# unikn::seecol(oxford_link, main = "Link colours of University of Oxford", col_bg = "lightgrey")




# - oxford_shades: Shades of Oxford University ------

#' Shade colours of University of Oxford, England, UK
#'
#' \code{oxford_shades} provides the seven shade colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#'
#' The 7 shade colours are
#' \code{"black"} (defined as HEX #000000),
#' \code{"off_black"} (defined as HEX #333333),
#' \code{"mid_grey"} (defined as HEX #7a736e),
#' \code{"dark_grey"} (defined as HEX #a6a6a6),
#' \code{"light_grey"} (defined as HEX #e0ded9),
#' \code{"light_grey"} (defined as HEX #f9f8f5), and
#' \code{"white"} (defined as HEX #ffffff).
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-19.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_shades
#' unikn::seecol(oxford_shades, main = "Uni Oxford shade colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_shades <- unikn::newpal(col = c(col_shades_1, col_shades_2, col_shades_3, col_shades_4, 
                                       col_shades_5, col_shades_6, col_shades_7),
                               names = c(name_shades_1, name_shades_2, name_shades_3, name_shades_4, 
                                         name_shades_5, name_shades_6, name_shades_7),
                               as_df = FALSE)

# # Check: 
# unikn::seecol(oxford_shades, main = "Shade colours of University of Oxford", col_bg = "lightgrey")




# - oxford_blog: Custom blog colours of Oxford University ------

#' Custom blog colours of University of Oxford, England, UK
#'
#' \code{oxford_blog} provides the six custom blog colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#'
#' The 6 custom blog colours are
#' \code{"science_blog"} (defined as HEX #0f7361),
#' \code{"science_blog_button"} (defined as HEX #09332b),
#' \code{"arts_blog"} (defined as HEX #721627),
#' \code{"arts_blog_button"} (defined as HEX #330d14),
#' \code{"books_blog"} (defined as HEX #cf7a30) and
#' \code{"books_blog_button"} (defined as HEX #9c4700).
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_blog
#' unikn::seecol(oxford_blog, main = "Uni Oxford custom blog colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_blog <- unikn::newpal(col = c(col_blog_1, col_blog_2, col_blog_3, col_blog_4, col_blog_5, col_blog_6),
                             names = c(name_blog_1, name_blog_2, name_blog_3, name_blog_4, name_blog_5, name_blog_6),
                             as_df = FALSE)


# # Check: 
# unikn::seecol(oxford_blog, main = "Custom blog colours of University of Oxford", col_bg = "lightgrey")




# - oxford_graduate: Graduate country page colours of Oxford University ------

#' Graduate country page colours of University of Oxford, England, UK
#'
#' \code{oxford_graduate} provides the twelve graduate country page colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#'
#' The 23 graduate country page colours are
#' \code{"graduate_light_blue"} (defined as HEX #9eceeb),
#' \code{"graduate_blue"} (defined as HEX #5f9baf),
#' \code{"graduate_navy_blue"} (defined as HEX #44687d),
#' \code{"graduate_grey_blue"} (defined as HEX #a1c4d0),
#' \code{"graduate_dark_green"} (defined as HEX #69913b),
#' \code{"graduate_light_green"} (defined as HEX #aab300),
#' \code{"graduate_orange"} (defined as HEX #cf7a30),
#' \code{"graduate_yellow"} (defined as HEX #f5cf47),
#' \code{"graduate_dark_red"} (defined as HEX #872434),
#' \code{"graduate_red"} (defined as HEX #be0f34),
#' \code{"graduate_pink"} (defined as HEX #ebc4cb), and
#' \code{"graduate_grey"} (defined as HEX #a79d96).
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on 
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Oxford's digital style guide}.
#'
#' @examples
#' oxford_graduate
#' unikn::seecol(oxford_graduate, 
#'               main = "Uni Oxford graduate country page colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_graduate <- unikn::newpal(col = c(col_graduate_1, col_graduate_2, col_graduate_3, col_graduate_4, 
                                         col_graduate_5, col_graduate_6, col_graduate_7, col_graduate_8, 
                                         col_graduate_9, col_graduate_10, col_graduate_11, col_graduate_12),
                                 names = c(name_graduate_1, name_graduate_2, name_graduate_3, name_graduate_4, 
                                           name_graduate_5, name_graduate_6, name_graduate_7, name_graduate_8, 
                                           name_graduate_9, name_graduate_10, name_graduate_11, name_graduate_12),
                                 as_df = FALSE)

# # Check: 
# unikn::seecol(oxford_graduate, main = "Graduate country page colours of University of Oxford", col_bg = "lightgrey")




# - oxford_error: Error colours of Oxford University ------

#' Error colours of University of Oxford, England, UK 
#'
#' \code{oxford_error} provides the four error colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#'
#' The 4 error colours are
#' \code{"status"} (defined as HEX #7dbc23),
#' \code{"warning"} (defined as HEX #bc9a23),
#' \code{"error"} (defined as HEX #be0f34), and
#' \code{"error_light"} (defined as HEX #fff0f3),
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_error
#' unikn::seecol(oxford_error, main = "Uni Oxford error colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_error <- unikn::newpal(col = c(col_error_1, col_error_2, col_error_3, col_error_4),
                              names = c(name_error_1, name_error_2, name_error_3, name_error_4),
                              as_df = FALSE)

# # Check: 
#  unikn::seecol(oxford_error, main = "Error colours of University of Oxford", col_bg = "lightgrey")



# - oxford_socialmedia: Social media colours of Oxford University------

#' Social Media colours of University of Oxford, England, UK
#'
#' \code{oxford_socialmedia} provides the eleven social media colours 
#' of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
#'
#' The 11 social media colours are
#' \code{"cherry"} (defined as HEX #be0f34),
#' \code{"purple"} (defined as HEX #ac48bf),
#' \code{"red"} (defined as HEX #c7302b),
#' \code{"light_blue"} (defined as HEX #1daced),
#' \code{"deep_blue"} (defined as HEX #001c3d),
#' \code{"lagoon_blue"} (defined as HEX #006599),
#' \code{"weibo"} (defined as HEX #d62a2a),
#' \code{"green"} (defined as HEX #177770),
#' \code{"orange"} (defined as HEX #fb8113),
#' \code{"google_plus"} (defined as HEX #d34836), and
#' \code{"instagram"} (defined as HEX #517fa4),
#'
#' @return 
#' A named vector of colours (HEX/HTML codes of type character).
#'
#' @author 
#' \strong{unicol}, 2023-06-15.
#'
#' @source 
#' Colour definitions are based on the
#' \href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
#'
#' @examples
#' oxford_socialmedia
#' unikn::seecol(oxford_socialmedia, main = "Uni Oxford social media colours") # view colour palette
#'
#' @family English university color palettes
#'
#' @seealso
#' \code{\link{oxford_brand}} for the brand colours of University of Oxford;
#' \code{\link{oxford_general}} for the general colours of University of Oxford;
#' \code{\link{oxford_link}} for the link colours of University of Oxford;
#' \code{\link{oxford_shades}} for the shade colours of University of Oxford;
#' \code{\link{oxford_blog}} for the blog colours of University of Oxford;
#' \code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
#' \code{\link{oxford_error}} for the error colours of University of Oxford;
#' \code{\link{seecol}} for viewing and comparing colour palettes;
#' \code{\link{usecol}} for using colour palettes;
#' \code{\link{simcol}} for finding similar colours;
#' \code{\link{newpal}} for defining new colour palettes;
#' \code{\link{grepal}} for finding named colours.
#'
#' @export

oxford_socialmedia <- unikn::newpal(col = c(col_socialmedia_1, col_socialmedia_2, col_socialmedia_3, col_socialmedia_4, 
                                            col_socialmedia_5, col_socialmedia_6, col_socialmedia_7, col_socialmedia_8, 
                                            col_socialmedia_9, col_socialmedia_10, col_socialmedia_11),
                                    names = c(name_socialmedia_1, name_socialmedia_2, name_socialmedia_3, name_socialmedia_4, 
                                              name_socialmedia_5, name_socialmedia_6, name_socialmedia_7, name_socialmedia_8, 
                                              name_socialmedia_9, name_socialmedia_10, name_socialmedia_11),
                                    as_df = FALSE)

# # Check: 
# unikn::seecol(oxford_socialmedia, main = "Social Media colours of University of Oxford", col_bg = "lightgrey")




## ToDo: -------- 

# - etc.

## eof. ----------
