% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McGill.R
\docType{data}
\name{mcgill_muted}
\alias{mcgill_muted}
\title{Muted colours of McGill University, Canada}
\format{
An object of class \code{character} of length 6.
}
\source{
Colour definitions are based on the
\href{https://www.mcgill.ca/visual-identity/visual-identity-guide}{Visual Identity Guide}.
}
\usage{
mcgill_muted
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
McGill’s secondary colours, are not official but rather suggested colours that cover a larger spectrum to complement the McGill red.
They can be used to add variety and contrast for headings, bullets, background and other graphic elements.
}
\details{
\code{mcgill_muted} provides the muted colours 
of \href{https://www.mcgill.ca/}{McGill University}, Canada.

The muted colours are 
\code{"muted_1"} (defined as CMYK 13/72/76/2, RGB 211/103/74, HEX #D3674A),
\code{"muted_2"} (defined as CMYK 0/20/90/10, RGB 232/185/46, HEX #E8B92E),
\code{"muted_3"} (defined as CMYK 86/35/40/6, RGB 8/127/140, HEX #087F8C),
\code{"muted_4"} (defined as CMYK 80/10/0/15, RGB 0/150/201, HEX #0096C9),
\code{"muted_5"} (defined as CMYK 50/23/87/3, RGB 139/160/78, HEX #8BA04E), and
\code{"muted_6"} (defined as CMYK 40/76/33/6, RGB 155/86/120, HEX #9B5678).

\code{mcgill_muted} uses the HEX colour definitions. 

Note that CMYK colour values differ from RGB and HEX definitions.
}
\examples{
mcgill_muted
unikn::seecol(mcgill_muted, main = "Muted colours of McGill") # view colour palette

}
\seealso{
\code{\link{mcgill_red}} for the primary colour of McGill University;
\code{\link{mcgill_pastels}} for the pastel colours of McGill;
\code{\link{mcgill_brights}} for the bright colours of McGill;
\code{\link{mcgill_darks}} for the dark colours of McGill;
\code{\link{mcgill_grey}} for the grey of McGill;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
