% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stanford.R
\docType{data}
\name{stanford_3_web}
\alias{stanford_3_web}
\title{Web colors of Stanford University}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on the
\href{https://identity.stanford.edu/design-elements/color/}{Color manual}.
}
\usage{
stanford_3_web
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stanford_3_web} provides the nine web colors
of the \href{https://www.stanford.edu/}{Stanford University}, USA.
}
\details{
\code{"digital_red"} is not a replacement for Cardinal red—it can be used as an accent color on digital communications to add energy and emphasis.
\code{"digital_red_light"} can be used for interactive elements over dark backgrounds for contrast. 
\code{"digital_red_dark"} can be used for smaller text over light backgrounds.
Use \code{"digital_blue"} for links over light backgrounds, 
\code{"digital_blue_dark"} for link hover/focus states, and 
\code{"digital_blue_light"} for links over dark backgrounds. 
Do not use these shades of blue in contexts other than links.
Use \code{"digital_green"} for things such as form validation, 
\code{"digital_green_dark"} for link hover/focus states, and 
\code{"digital_green_light"} for links over dark backgrounds.

These nine web colors are
\code{"digital_red"} (defined as HEX #B1040E),
\code{"digital_red_light"} (defined as HEX #E50808),
\code{"digital_red_dark"} (defined as HEX #820000),
\code{"digital_blue"} (defined as HEX #006CB8),
\code{"digital_blue_light"} (defined as HEX #6FC3FF),
\code{"digital_blue_dark"} (defined as HEX #00548f),
\code{"digital_green"} (defined as HEX #008566),
\code{"digital_green_light"} (defined as HEX #1AECBA) and
\code{"digital_green_dark"} (defined as HEX #006F54).
}
\examples{
stanford_3_web
unikn::seecol(stanford_3_web, main = "Web colors Stanford University") # view color palette

}
\seealso{
\code{\link{stanford_1}} for primary colors of Stanford University;
\code{\link{stanford_2_accent}} for accent colors of Stanford University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
