% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Toronto.R
\docType{data}
\name{utoronto}
\alias{utoronto}
\title{Colors of the University of Toronto, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the   
\href{https://new.brand.utoronto.ca/principles-and-fundamentals/colour/}{U of T's Brand Portal}.
}
\usage{
utoronto
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{utoronto} provides the four colors of the University of Toronto
of the \href{https://www.utoronto.ca/}{University of Toronto}, Canada.
}
\details{
The four colors are
\code{"u_of_t_blue"}, (defined as RGB 37/53/90, HEX #25355A)
\code{"boundless_blue"} (defined as RGB 0/127/163, HEX #007FA3), 
\code{"black"} (defined as RGB 0/0/0, HEX #000000), and
\code{"light_grey"} (defined as RGB 242/244/247, HEX #F2F4F7).


\code{uni_pal_1} uses the HEX color definitions.
}
\examples{
utoronto
unikn::seecol(utoronto, main = "University of Toronto") # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
