% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UWaterloo.R
\docType{data}
\name{uwaterloo_science}
\alias{uwaterloo_science}
\title{Faculty of Science colors of the University of Waterloo, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the University of Waterloo's 
\href{https://uwaterloo.ca/brand/}{Brand home}.
}
\usage{
uwaterloo_science
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uwaterloo_science} provides the four blue color levels
of the \href{https://uwaterloo.ca}{University of Waterloo}, Canada.
}
\details{
Use the color Blue to identify content and communications from the Faculty of Science.

The 4 blue colors are 
\code{"Blue Level 1"} (defined as CMYK: 28 9 0 0, RGB:	180 213 255, HEX:	#B4D5FF),
\code{"Blue Level 2"} (defined as CMYK: 62 28 2 3, RGB:	99 160 255, HEX:	#63A0FF),
\code{"Blue Level 3"} (print primary color) (defined as CMYK: 90 48 0 0, RGB:	0 115 206, HEX:	#0073CE), and
\code{"Blue Level 4"} (digital primary color) (defined as CMYK: 100 75 0 5, RGB:	0 51 190, HEX: #0033BE).

\code{uwaterloo_science} uses the HEX color definitions.
}
\examples{
uwaterloo_science
unikn::seecol(uwaterloo_science, main = "Science faculty colors of UWaterloo") 
# view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
