% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunifed.R
\name{dunifed}
\alias{dunifed}
\alias{punifed}
\alias{qunifed}
\alias{runifed}
\title{The unifed distribution}
\usage{
dunifed(x, theta)

punifed(q, theta)

qunifed(p, theta)

runifed(n, theta)
}
\arguments{
\item{x}{A vector of quantiles. They must be numbers between 0 and 1.}

\item{theta}{The value of the canonical parameter. It must be of length one.}

\item{q}{A vector of quantiles.}

\item{p}{A vector of probabilities.}

\item{n}{number of observations}
}
\value{
\code{dunifed} gives the density function.

\code{punifed} gives the distribution function.

\code{qunifed} gives the quantile function.

\code{runifed} generates random observations.
}
\description{
Density, distribution function, quantile function and
    random generation for the unifed distribution.
}
\examples{

dunifed( c(0.1,0.3,0.7), 10)


x <- c(0.1,0.4,0.7,1)
punifed(x,-5)


p <- 1:9/10
qunifed(p,5)


runifed(20,-3.3)

}
\references{
{
Quijano Xacur, Oscar Alberto (2018). The Unifed Distribution. ArXiv. \url{http://arxiv.org/abs/1812.00251}.

}
}
