% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_2.R
\docType{data}
\name{pal_unikn_light}
\alias{pal_unikn_light}
\title{uni.kn light colors in a color palette.}
\format{An object of class \code{data.frame} with 1 rows and 10 columns.}
\usage{
pal_unikn_light
}
\description{
\code{pal_unikn_light} provides an additional uni.kn color palette  
that collects 2 light colors of 4 color palettes  
as a data frame containing 8 colors (in 4 pairs).
}
\details{
See \url{https://www.uni-konstanz.de} for details.
}
\examples{
pal_unikn_light
dim(pal_unikn_light)  # 1 8 

# Access by position:
pal_unikn_light[1]    # color "seeblau3" (as df)
pal_unikn_light[[1]]  # color value "#59C7EB" 

# Access by name: 
pal_unikn_light["seeblau3"]   # color "seeblau3" (as df) 
pal_unikn_light[["seeblau3"]] # color value "#59C7EB"  

# Plotting palette:
seecol(pal_unikn_light)

}
\seealso{
\code{\link{pal_unikn_dark}} for a darker uni.kn color palette; 
\code{\link{pal_unikn_pair}} for a pairwise uni.kn color palette; 
\code{\link{pal_unikn}} for the default uni.kn color palette; 
\code{\link{seecol}} to show color palettes;
\code{\link{usecol}} to use color palettes.

Other color palettes: \code{\link{pal_bordeaux}},
  \code{\link{pal_grau}}, \code{\link{pal_karpfenblau}},
  \code{\link{pal_peach}}, \code{\link{pal_petrol}},
  \code{\link{pal_pinky}}, \code{\link{pal_seeblau}},
  \code{\link{pal_seegruen}}, \code{\link{pal_signal}},
  \code{\link{pal_unikn_dark}},
  \code{\link{pal_unikn_pair}},
  \code{\link{pal_unikn_ppt}},
  \code{\link{pal_unikn_pref}},
  \code{\link{pal_unikn_web}}, \code{\link{pal_unikn}}
}
\concept{color palettes}
\keyword{datasets}
