% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{eth_pal_grey}
\alias{eth_pal_grey}
\title{Black and grey colors of the ETH Zurich.}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://ethz.ch/staffnet/en/service/communication/corporate-design/digital-media/web-colours.html}.
}
\usage{
eth_pal_grey
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{eth_pal_grey} provides the shades of black and grey 
used by the \href{https://ethz.ch/}{ETH Zürich}, Switzerland.
}
\details{
These shades of gray can be used to visually structure content 
and delineate different elements. 

Note that \code{eth_pal_grey} mixes colors of 
varying opacity / transparency levels.
}
\examples{
eth_pal_grey
seecol(eth_pal_grey)  # view color palette
demopal(eth_pal_grey, type = 2, main = "Black and grey colors of the ETH Zürich")

}
\seealso{
\code{\link{eth_pal}} and \code{\link{eth_pal_light}} for alternative colors of the ETH Zurich;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{eth_pal_light}},
\code{\link{eth_pal}},
\code{\link{mpg_pal}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_konstanz_pref}},
\code{\link{uni_konstanz}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}}
}
\author{
Hansjoerg Neth, 2022-10-25.
}
\concept{contributed color palettes}
\keyword{datasets}
