% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{units}
\alias{units}
\alias{units<-.numeric}
\alias{units}
\alias{units<-.units}
\alias{units}
\alias{set_units}
\alias{units}
\alias{set_units.units}
\alias{units}
\alias{set_units.numeric}
\alias{units}
\alias{units.units}
\title{Set measurement units on a numeric vector}
\usage{
\method{units}{numeric}(x) <- value

\method{units}{units}(x) <- value

set_units(x, value, ...)

\method{set_units}{units}(x, value, ...)

\method{set_units}{numeric}(x, value = units::unitless, ...)

\method{units}{units}(x)
}
\arguments{
\item{x}{numeric vector, or object of class \code{units}}

\item{value}{object of class \code{units} or \code{symbolic_units}, or in the case of \code{set_units} expression with symbols that can be resolved in \link{ud_units} (see examples).}

\item{...}{ignored}
}
\value{
object of class \code{units}

the units method retrieves the units attribute, which is of class \code{symbolic_units}
}
\description{
Set measurement units on a numeric vector

Convert units

retrieve measurement units from \code{units} object
}
\details{
\code{set_units} is a pipe-friendly version of \code{units<-} that evaluates \code{value} first in the environment of \link{ud_units}.
}
\examples{
x = 1:3
class(x)
units(x) <- with(ud_units, m/s) # valid
class(x)
y = 2:5
a <- with(ud_units, 1:3 * m/s)
units(a) <- with(ud_units, km/h)
a
# note that these units have NOT been defined or declared before:
set_units(1:5, N/m^2)
set_units(1:5, unitless) # unit "1", unitless
if (require(magrittr)) {
 1:5 \%>\% set_units(N/m^2)
 1:10 \%>\% set_units(m) \%>\% set_units(km)
}
}
