% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndims.R
\name{ndims}
\alias{ndims}
\alias{ndims.default}
\alias{ndims.matrix}
\alias{ndims.data.frame}
\title{Number of Dimensions}
\usage{
ndims(x, ...)

\method{ndims}{default}(x, ...)

\method{ndims}{matrix}(x, ...)

\method{ndims}{data.frame}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A integer scalar of the number of dimensions.
}
\description{
Gets the number of dimensions of an object as returned by \code{dims()}.

The default methods returns the length of \code{\link[=dims]{dims()}}.
}
\details{
For matrices \code{ndims()} is always 2L.

For data frames \code{ndims()} is always 2L.
}
\examples{
ndims(character(0))
ndims(1:3)
ndims(matrix(1))
ndims(data.frame())
ndims(array(1:9, dim = c(3,1,3)))
}
\seealso{
Other dimensions: 
\code{\link{dims}()},
\code{\link{npdims}()},
\code{\link{pdims}()}
}
\concept{dimensions}
